#ifndef __VM_MAPS__
#define __VM_MAPS__
/**************************************************************************
 * VMMAP_READ  -  memory is readonly. On systems withot DEP this flag also 
 *                means that memory is EXEC
 * VMMAP_WRITE -  memory is writable and thus we have to check it always for
 *                changes
 * VMMAP_EXEC  -  memory is executable (on systems without DEP) this is same
 *                as vmread 
 * VMMAP_WAS_WRITE - memory was allocated as EXEC or READ, but latter it's 
 *                   protection was changed to VMMAP_WRITE, during some 
 *                   operation, code was changed latter back to EXEC or READ
 *                   thus this means that memory was changed at some point
 *                   and should be inspected again (maybe it wasn't changed)
 *                   This mostly case of Hooking APIs by browsers, and 
 *                   sandboxes!!
 **************************************************************************/

#define VMMAP_READ      0x01    //memory is read
#define VMMAP_WRITE     0x02    //memory is write
#define VMMAP_EXEC      0x04    //memory is exec
#define VMMAP_GUARD     0x40    //memory is guard protected
#define VMMAP_WAS_WRITE 0x80    //at some point memory was set to WRITE


typedef struct _vmmap_area{
        unsigned long   vmmap_base;             //used to track NtUnmapViewOfSection
        unsigned long   vmmap_protection;       //protection type
        bbl_struct      *pbbl_prev;             //previos page basic block
        bbl_struct      *pbbl_next;             //next    page basic block
        LIST            bbl_list;               //list    of pages ansigned for this page
        pbbl_struct     *pbbl_array;            //fast lookup for bbls...
}vmmap_area, *pvmmap_area;


typedef struct _vmmap_struct{
        LIST            Next;
        unsigned long   vmmap_base;
        unsigned long   vmmap_size;
}vmmap_struct, *pvmmap_struct;

void    vmmapAddkRange(__in void *lpBuffer, __in unsigned long size);
void    vmmapAdd(__in void *lpBuffer, __in unsigned long size, __in unsigned long dwProtection);
void    vmmapRemove(__in void *lpBuffer, __in unsigned long size);
unsigned long vmmapGetProtection(__in void *lpBuffer);
unsigned long vmmapRemoveRange(__in void *lpBuffer);
void    vmmapChangeProtection(__in void *lpBuffer, __in unsigned long size, __in unsigned long dwProtection);
void    vmmapRemoveWasWrite(__in void *lpBuffer);

pvmmap_area vmmap_get_area(__in void *ptr);
void    vmmap_delete_area(__in void *ptr);

#endif