#include        "defs.h"

LPVOID WINAPI ntVirtualAllocEx(
  __in      HANDLE hProcess,
  __in_opt  LPVOID lpAddress,
  __in      SIZE_T dwSize,
  __in      DWORD flAllocationType,
  __in      DWORD flProtect
){
        NTSTATUS  status;
        SIZE_T    RegionSize = dwSize;
        status = NtAllocateVirtualMemory(hProcess,
                                         &lpAddress,
                                         0,
                                         &RegionSize,
                                         flAllocationType,
                                         flProtect);
                
        
        return (status == STATUS_SUCCESS) ? lpAddress : NULL;
}

LPVOID WINAPI ntVirtualAlloc(
  __in_opt  LPVOID lpAddress,
  __in      SIZE_T dwSize,
  __in      DWORD flAllocationType,
  __in      DWORD flProtect
){
        return ntVirtualAllocEx((HANDLE)(ULONG_PTR)-1,
                              lpAddress,
                              dwSize,
                              flAllocationType,
                              flProtect);
}


BOOL WINAPI ntVirtualFreeEx(
  __in  HANDLE hProcess,
  __in  LPVOID lpAddress,
  __in  SIZE_T dwSize,
  __in  DWORD dwFreeType
){
        NTSTATUS status;
        
        status = NtFreeVirtualMemory(hProcess,
                                     &lpAddress,
                                     &dwSize,
                                     dwFreeType);
        return (status == STATUS_SUCCESS) ? TRUE : FALSE;
}

BOOL WINAPI ntVirtualFree(
  __in  LPVOID lpAddress,
  __in  SIZE_T dwSize,
  __in  DWORD dwFreeType
){
        return ntVirtualFreeEx((HANDLE)(ULONG_PTR)-1,
                             lpAddress,
                             dwSize,
                             dwFreeType);
}


   
BOOL WINAPI ntVirtualProtectEx(
  __in   HANDLE hProcess,
  __in   LPVOID lpAddress,
  __in   SIZE_T dwSize,
  __in   DWORD flNewProtect,
  __out  PDWORD lpflOldProtect
){
        NTSTATUS        status;
        
        status = NtProtectVirtualMemory(hProcess, 
                                        &lpAddress,
                                        &dwSize,
                                        flNewProtect,
                                        lpflOldProtect);
        return (status == STATUS_SUCCESS) ? TRUE : FALSE;
}

BOOL WINAPI ntVirtualProtect(
  __in   LPVOID lpAddress,
  __in   SIZE_T dwSize,
  __in   DWORD flNewProtect,
  __out  PDWORD lpflOldProtect
){
        return ntVirtualProtectEx((HANDLE)(ULONG_PTR)-1,
                                   lpAddress,
                                   dwSize,
                                   flNewProtect,
                                   lpflOldProtect);
}


SIZE_T WINAPI ntVirtualQueryEx(
  __in      HANDLE hProcess,
  __in_opt  LPCVOID lpAddress,
  __out     PMEMORY_BASIC_INFORMATION lpBuffer,
  __in      SIZE_T dwLength
){
        NTSTATUS        status;
        SIZE_T          cbReturned;
        
        
        status  = NtQueryVirtualMemory(hProcess,
                                       (PVOID)lpAddress,
                                       MemoryBasicInformation,
                                       lpBuffer,
                                       dwLength,
                                       &cbReturned);

        return (status == STATUS_SUCCESS) ? cbReturned : 0;
}

SIZE_T WINAPI ntVirtualQuery(
  __in_opt  LPCVOID lpAddress,
  __out     PMEMORY_BASIC_INFORMATION lpBuffer,
  __in      SIZE_T dwLength
){
        return ntVirtualQueryEx((HANDLE)(ULONG_PTR)-1,
                                lpAddress,
                                lpBuffer,
                                dwLength);
}




