program GifInfo;

{$A+,B-,D+,E-,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V+,X+}
{$M 16384,0,655360}

uses Dos;

const
  FC_SAVED = 249;

function Gif(S : String) : String;
  var
    D : DirStr;
    N : NameStr;
    E : ExtStr;
  begin
    FSplit(FExpand(S), D,N,E);
    if E = '' then E := '.GIF';
    Gif := D+N+E;
  end;

type
  TGifHeader = record
    ID, Ver     : array[1..3] of Char;
  end;

  TGifScreenDescriptor = record
    XSize       : Word;
    YSize       : Word;
    Bits        : Byte;
    Background  : Byte;
    Unused      : Byte;
  end;

  TRGB = record
           R,G,B : Byte;
         end;

  TGifColorMap = array[Byte] of TRGB;

  TGifImageDescriptor = record
    LeftX       : Word;
    UpX         : Word;
    XSize       : Word;
    YSize       : Word;
    Bits        : Byte;
  end;

var
  F,FO : File;

procedure FRead(var V; VSize : Word);
  var
    Test : Word;
  begin
    blockread(F, V, VSize, Test);
    if Test <> VSize then
    begin
      writeln('Error reading file');
      Halt(3);
    end;
  end;

procedure FWrite(var V; VSize : Word);
  var
    Test : Word;
  begin
    blockwrite(FO, V, VSize, Test);
  end;

var
  H          : TGifHeader;
  SD         : TGifScreenDescriptor;
  GCElements : Word;
  GC         : TGifColorMap;
  C          : Char;
  B, FC      : Byte;
  ID         : TGifImageDescriptor;
  LCElements : Word;
  LC         : TGifColorMap;
  i,j,k      : Word;
  SSS        : String;

const
  Msg1 : array[0..1] of PChar = ('Absent', 'Present');
  Msg2 : array[0..1] of PChar = ('Global', 'Local');
  Msg3 : array[0..1] of PChar = ('Non-', '');

begin
  writeln('GIF file comment stripper  Version 2.xx   (c) 1997-1999');

  if ParamCount <> 2 then
  begin
    writeln('Syntax: GIFSTRIP infile[.GIF] outfile[.GIF]');
    Halt(1);
  end;

  assign(Output, 'GIFINFO.TXT');
  rewrite(Output);

  assign(FO,paramstr(2));
  rewrite(FO,1);

  writeln('File: ',Gif(ParamStr(1)));

  assign(F, Gif(ParamStr(1)));
  reset(F,1);
  if IOResult <> 0 then
  begin
    writeln('File not found');
    Halt(2);
  end;

  FRead(H, sizeof(H));
  FWrite(H, sizeof(H));

  if H.ID <> 'GIF' then
  begin
    writeln('Not a GIF file');
    Halt(4);
  end;

  writeln('Header');
  writeln('    Version............',H.Ver);

  FRead(SD, sizeof(SD));
  FWrite(SD, sizeof(SD));

  writeln('Screen Descriptor');
  writeln('    XSize..............',SD.XSize);
  writeln('    YSize..............',SD.YSize);
  writeln('    Bits:');
  writeln('        M (1)..........',SD.Bits shr 7 and 1,'    Global Color Map: ',Msg1[SD.Bits and 1]);
  writeln('        R (3)..........',SD.Bits shr 6 and 7,'    ',1 + SD.Bits shr 6 and 7, '-Bit color');
  writeln('        X (1)..........',SD.Bits shr 3 and 1);
  writeln('        C (3)..........',SD.Bits shr 0 and 7,'    ',1 shl (1 + SD.Bits shr 0 and 7),' colors');
  writeln('    Background.........',SD.Background);
  writeln('    Unused.............',SD.Unused);

  if SD.Bits shr 7 and 1 = 1 then
  begin

    GCElements := 1 shl (1 + SD.Bits and 7);

    FRead(GC, GCElements * SizeOf(TRGB));
    FWrite(GC, GCElements * SizeOf(TRGB));

    writeln('Global Color Map');
    writeln('    Elements...........', GCElements);
    writeln('    Size...............', GCElements * SizeOf(TRGB), ' Byte(s)');
    writeln('    Colors:');

    for i := 0 to GCElements-1 do
      writeln('        ',i:3,'    ',GC[i].R:3,':',GC[i].G:3,':',GC[i].B:3);
  end;

  repeat

    FRead(C, 1);
    FWrite(C, 1);

    case C of
      ';': begin
             writeln('GIF Terminator');
             Break;
           end;

      ',': begin
             writeln('Image Descriptor');

             FRead(ID, sizeof(ID));
             FWrite(ID, sizeof(ID));

             writeln('    LeftX..............', ID.LeftX);
             writeln('    UpX................', ID.UpX);
             writeln('    XSize..............', ID.XSize);
             writeln('    YSize..............', ID.YSize);
             writeln('    Bits:');
             writeln('        (1) ...........', ID.Bits shr 7 and 1,'    Use ',Msg2[ID.Bits shr 7 and 1],' Color Map');
             writeln('        (1) ...........', ID.Bits shr 6 and 1,'    ',Msg3[ID.Bits shr 6 and 1],'Interlaced Image');
             writeln('        (3) ...........', ID.Bits shr 5 and 7);
             writeln('        (3) ...........', ID.Bits shr 0 and 7,'    ',1 + ID.Bits shr 0 and 7,'-Bit color');

             if ID.Bits shr 7 and 1 = 1 then
             begin

               LCElements := 1 + ID.Bits shr 0 and 7;

               writeln('Local Color Map');
               writeln('    Elements...........', LCElements);
               writeln('    Size...............', LCElements * SizeOf(TRGB), ' Byte(s)');

               FRead(LC, LCElements * sizeof(TRGB));
               FWrite(LC, LCElements * sizeof(TRGB));

               writeln('    Colors:');
               for i := 0 to LCElements-1 do
                 writeln('        ',i:3,'    ',LC[i].R:3,':',LC[i].G:3,':',LC[i].B:3);

             end;

           end;

      '!': begin
             writeln('Extension Block');

             FRead(FC, 1);

             IF FC<>FC_SAVED then seek(FO,filepos(FO)-1);

             IF FC=FC_SAVED then
             FWrite(FC, 1);

             writeln('    FunctionCode.......', FC);

             repeat
               FRead(B, 1);
               IF FC=FC_SAVED then
               FWrite(B, 1);
               if B = 0 then Break;

               writeln('    DataSize...........', B);
               write  ('    Data...............');
               k := 0;

               for i := 1 to B do
               begin
                 FRead(C, 1);
                 IF FC=FC_SAVED then
                 FWrite(C, 1);
                 if (C in [#0,#13,#10,#7,#255]) then begin
                   if k = 1 then write('''');
                   k := 0;
                   write('#',ord(C))
                 end else begin
                   if k = 0 then write('''');
                   k := 1;
                   write(C);
                 end;
               end;

               if k = 1 then write('''');
               writeln;

             until false;

             writeln('    Terminator');

           end;

      else begin
             writeln('Raster Block');

             B := ord(C);

             writeln('    PixelSize..........',B);

             write  ('    DataSize...........');
             repeat
               FRead(B, 1);
               FWrite(B, 1);
               if B = 0 then Break;
               write(B,' ');
               FRead(SSS,B);
               FWrite(SSS,B);
               {Seek(F, FilePos(F) + B);}
             until false;

             writeln;
             writeln('    Terminator');

           end;
    end;

  until false;

  close(F);

  close(Output);
  close(FO);
end.

