uses crt;

const
  INFILE  = 'EXAMPLE.BMP';
  OUTFILE = 'EXAMPLE.TXT';

  DISPX =  23;
  DISPY =  10;

  MAXX = 640;
  MAXY = 400;
  XN = 4;
  YN = 5;
  MAXXF = (MAXX + 3) and (not 3);
  XX = MAXX div XN;
  YY = MAXY div YN;

  FN = 6;      { INT10H, AX=1130H, BH=.. }
  FX = 8;
  FY = 16;


type
  tfontchar = array[0..FY-1] of byte;

  pfont = ^tfont;
  tfont = array[byte] of tfontchar;

var
  font : pfont;

  f : file;
  t : text;

  buf : array[0..YY-1,0..XX-1] of byte;
  max : word;

  l : longint;
  z,i,j,k,n, i1,i2, x,y, x1,y1, x2,y2,
    x3,y3, t1,t2,t3,t4, m1,m2 : integer;

  s : string;

  cc, dd : tfontchar;

begin
  inline($b8/$03/$00/$cd/$10);

  {
  asm
    push bp
    mov ax, 1130h
    mov bh, FN
    int 10h
    mov font.word ptr 0, bp
    mov font.word ptr 2, es
    pop bp
  end;
  }
  getmem(font, sizeof(tfont));
  assign(f,'8X16.FNT');
  reset(f,1);
  blockread(f,font^,sizeof(tfont),max);
  close(f);

  assign(f,infile);
  filemode := 0;
  reset(f,1);

  while not eof(f) do
    blockread(f, buf, sizeof(buf), max);

  for y1 := 0 to YN-1 do
  for x1 := 0 to XN-1 do
  begin
    for i := 0 to YY-1 do
    begin
      l := 1078 + longint(MAXY-1- (y1*YY+i - DISPY)) * MAXXF + x1*XX - DISPX;
      seek(f, l);
      blockread(f, buf[i,0], XX, max);
    end;

    for y2 := 0 to YY div FY-1 do
    for x2 := 0 to XX div FX-1 do
    begin

      t1 := y1*YY+y2*FY;
      t2 := x1*XX+x2*FX;
      t3 := y2*FY;
      t4 := x2*FX;

      m1 := 32767;
      m2 := 0;

      fillchar(cc, sizeof(cc), 0);
      for y3 := 0 to FY-1 do
      for x3 := 0 to FX-1 do
      begin
        i := byte(buf[t3+y3,t4+x3] <> 0);
        cc[y3] := cc[y3] or (i shl (7-x3));
      end;

      gotoxy(1+t2 div FX,1+t1 div FY);
      mem[segb800:(t1 div FY) * 160 + (t2 div FX) * 2] := $F0;

      for k := 32 to 127 do
      begin
        move(font^[k], dd, sizeof(dd));

        {
        j := 0;
        for y := 0 to FY-1 do
        begin
          i := cc[y] xor dd[y];
          for x := 0 to FX-1 do
          begin
            z := 0;
            if sqr(t1+y-150.0-16*3)*1.4 + sqr(t2+x-320.0) <= 190*190 then z := 1;
            inc(j, ((i shr x) and 1) xor z);
          end;
        end;
        }

        asm
          mov si, FY-1
          xor di, di

@@x:      mov al, byte ptr cc[si]
          xor al, byte ptr dd[si]

          not al

@@2:      shr al, 1
          jnc @@1
          lea di, [di+1]
@@1:      jnz @@2

          dec si
          jge @@x

          mov j, di
        end;


        if j < m1 then
        begin
          m1 := j;
          m2 := k;
        end;

        if m1 = 0 then break;

      end;

      mem[segb800:(t1 div FY) * 160 + (t2 div FX) * 2] := m2;

    end;
  end;

  close(f);

  assign(t, outfile);
  rewrite(t);
  for y := 0 to 23 do
  begin
    for x := 0 to 79 do
      s[x+1] := chr(mem[segb800:y*160+x*2]);
    s[0] := #80;
    while (s<>'') and (s[length(s)] in [#0,#32,#255]) do
      dec(s[0]);
    writeln(t,s);
  end;
  close(t);

end.
