
#ifdef WIN32
#include <windows.h>
#include <wincrypt.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <io.h>
#include <dos.h>
#include <direct.h>
#include <math.h>
#include <time.h>
#include <tlhelp32.h>
#endif // WIN32

#ifdef LINUX
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <time.h>
#include <pthread.h>
#include <unistd.h>
#include <fcntl.h>
#include <resolv.h>
#include <netdb.h>
#include <netinet/in.h>
#include <memory.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <arpa/inet.h>
#include <signal.h>
#endif // LINUX
#pragma hdrstop

#ifdef WIN32
#define MSG_NOSIGNAL   0
#define socklen_t      int
#define snprintf       _snprintf
#define vsnprintf      _vsnprintf
#endif
#ifdef LINUX
#define SOCKET         int
#define WINAPI
#define PASCAL
#define closesocket    close
typedef unsigned char  BYTE;
typedef unsigned long  DWORD;
#endif

#define MAXOBJECTS      1024

#define STATUS_UNUSED   1
#define STATUS_LISTEN   2
#define STATUS_IO       3

int         status[MAXOBJECTS];
sockaddr_in addr  [MAXOBJECTS];
SOCKET      sock  [MAXOBJECTS];
int         lnk  [MAXOBJECTS];

int find_unused_id()
{
  for(int i=0; i<MAXOBJECTS; i++)
    if (status[i] == STATUS_UNUSED)
      return i;
  return -1;
}

void my_close_socket(int i)
{
  for(int j=0; j<MAXOBJECTS; j++)
  if (status[j] == STATUS_IO)
  if (lnk[j] == i)
  {
    lnk[j] = -1;
    break;
  }
  status[i] = STATUS_UNUSED;
  memset(&addr[i], 0, sizeof(sockaddr));
  closesocket(sock[i]); sock[i] = 0;
  lnk[i] = -1;
}

int my_listen_socket(int i, int l, unsigned short port)
{
  if (status[i] != STATUS_UNUSED)
    return 0;

  sock[i] = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
  if ((sock[i] == 0) || (sock[i] == -1))
    return 0;

  addr[i].sin_family      = AF_INET;
  addr[i].sin_port        = htons(port);
  addr[i].sin_addr.s_addr = 0;

  if (bind(sock[i], (sockaddr*)&addr[i], sizeof(sockaddr)) != 0)
  {
    my_close_socket(sock[i]);
    return 0;
  }

  if (listen(sock[i], SOMAXCONN) != 0)
  {
    my_close_socket(sock[i]);
    return 0;
  }

  status[i] = STATUS_LISTEN;
  lnk  [i] = l;

  //printf("created listen %d\n", i);

  return 1;
}

int ctl_send(int i, char* fmt, ...)
{
  static char s[8192];

  va_list va;
  va_start(va, fmt);
  vsnprintf(s, sizeof(s)-1, fmt, va);
  va_end(va);

  if (send(sock[i], s, strlen(s), MSG_NOSIGNAL) != (int)strlen(s))
  {
    my_close_socket(i);
    //printf("killed control %d\n", i);
    return 0;
  }

  return 1;
}

#define MAXTOKEN        3
#define MAXLINE         1024
char token[MAXTOKEN][MAXLINE];
int  token_n = 0;

char* get_token(char* text)
{

  if ((text == NULL) || (*text == 0))
    return NULL;

  token_n = (token_n + 1) % MAXTOKEN;

#define IS_SPACE(x)  (((x)==32)||((x)==9)||((x)==13)||((x)==10))

  while(IS_SPACE(*text)) text++;

  char* z = 0;
  for(char* x=text; *x; x++)
  if (IS_SPACE(*x))
  {
    z = x;
    break;
  }

  int q=0;

  if (text[0]=='"')
  {
    z = text+1;
    while((*z!=0)&&(*z!='"')) z++;
    z++;
    q=1;
  }
  else
  if (text[0]=='\x27')
  {
    z = text+1;
    while((*z!=0)&&(*z!='\x27')) z++;
    z++;
    q=1;
  }

  if (z)
  {
    strncpy(token[token_n], text, z-text);
    token[token_n][z-text] = 0;
    strcpy(text, z+1);
    if (q) { strcpy(token[token_n],token[token_n]+1); token[token_n][strlen(token[token_n])-1]=0; };
    return token[token_n];
  }
  else
  {
    strcpy(token[token_n], text);
    text[0] = 0;
    if (q) { strcpy(token[token_n],token[token_n]+1); token[token_n][strlen(token[token_n])-1]=0; };
    if (token[token_n][0] == 0)
      return NULL;
    else
      return token[token_n];
  }

  return NULL;
} // get_token

void control(int i, char* data, int size)
{
  data[size] = 0;
  char *a1, *a2;

  while(char* text = get_token(data))
  {

    if (!strcmp(text,"help"))
    {
      if (!ctl_send(i,
                    "commands:\r\n"
                    "  help\r\n"
                    "  show\r\n"
                    "  exit\r\n"
                    "  listen <port>\r\n"
                    "  listenctl <port>\r\n"
                    "  kill <id>\r\n"
                    "  link <id> <id>\r\n"
                    )) return;
    }
    else
    if (!strcmp(text,"show"))
    {
      for(int j=0; j<MAXOBJECTS; j++)
      if (status[j] != STATUS_UNUSED)
      {
        if (!ctl_send(i,
                      "id=%d status=%s addr=%s:%d lnk=%d\r\n",
                      j,
                      status[j]==STATUS_LISTEN?
                        (lnk[j]==-1?"LISTEN-->IO":"LISTEN-->CONTROL") :
                        (lnk[j]==-1?"IO-->UNCONNECTED":
                          lnk[j]==-2?"IO-->CONTROL":"IO"),
                      inet_ntoa(addr[j].sin_addr),
                      ntohs(addr[j].sin_port),
                      lnk[j]
                     )
           )
        return;
      }
    }
    else
    if (!strcmp(text,"exit"))
    {
      my_close_socket(i);
      return;
    }
    else
    if ( (!strcmp(text,"kill")) &&
         ((a1 = get_token(data)) != NULL) )
    {
      int id = atoi(a1);
      if ((id > 0) && (id < MAXOBJECTS) && (status[id] != STATUS_UNUSED))
      {
        my_close_socket(id);
        if (id == i) return;
      }
    }
    else
    if ( (!strcmp(text,"link")) &&
         ((a1 = get_token(data)) != NULL) &&
         ((a2 = get_token(data)) != NULL) )
    {
      int id1 = atoi(a1);
      int id2 = atoi(a2);
      if ((id1 > 0) && (id1 < MAXOBJECTS) && (status[id1] != STATUS_UNUSED))
      if ((id2 > 0) && (id2 < MAXOBJECTS) && (status[id2] != STATUS_UNUSED))
      {
        if (!ctl_send(i, "interlinked %d and %d\r\n", id1, id2)) return;
        lnk[id1] = id2;
        lnk[id2] = id1;
      }
      return;
    }
    else
    if ( (!strcmp(text,"listen")) &&
         ((a1 = get_token(data)) != NULL) )
    {
      int port = atoi(a1);
      int j = find_unused_id();
      if (j != -1)
        my_listen_socket(j, -1, port);
    }
    else
    if ( (!strcmp(text,"listenctl")) &&
         ((a1 = get_token(data)) != NULL) )
    {
      int port = atoi(a1);
      int j = find_unused_id();
      if (j != -1)
        my_listen_socket(j, -2, port);
    }
    else
    {
      if (!ctl_send(i, "error(\"%s\")\r\n", text)) return;
    }

  } // for each token

} // control

#ifdef WIN32
int PASCAL WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
#endif
#ifdef LINUX
int main()
#endif
{

#ifdef WIN32
  WSADATA WSAData;
  WSAStartup(MAKEWORD(1,1), &WSAData);
#endif

#ifdef LINUX
  printf("pid=%d\n", getpid()+1);
  if (daemon(/*nochdir==*/1,/*noclose==*/0) != 0)
    exit(0);
#endif

  int i,j,res;

  for(i=0; i<MAXOBJECTS; i++)
  {
    status[i] = STATUS_UNUSED;
    sock  [i] = 0;
    memset(&addr[i], 0, sizeof(sockaddr));
    lnk   [i] = -1;
  }

  my_listen_socket(0, -2, 666);

  for(;;) // main cycle
  {

    int idle = 1;

    for(i=0; i<MAXOBJECTS; i++)
    {

      switch(status[i])
      {

        case STATUS_LISTEN:
             {

               fd_set readfds;
               FD_ZERO(&readfds);
               FD_SET(sock[i], &readfds);

               timeval to = {0,0};

               res = select(sock[i], &readfds, NULL, NULL, &to);

               if (res == -1)
               {
                 idle = 0;

                 //printf("killed listen %d\n", i);

                 my_close_socket(i);
                 break;
               } // res == -1

               if (res == 1)
               {
                 idle = 0;

                 j = find_unused_id();
                 if (j != -1)
                 {
                   socklen_t addrlen;
                   sock[j] = accept(sock[i], (sockaddr*)&addr[j], &addrlen);
                   if ((sock[j] != 0) && (sock[j] != -1))
                   {
                     status[j] = STATUS_IO;
                     lnk  [j] = lnk[i];

                     //printf("accepted %d from %d, lnk set to %d\n", j, i, lnk[j]);

                     if (lnk[j] == -2)
                       ctl_send(j, "tcp-switch v1.00\r\n");
                   }
                 }
               } // res == 1

             }
             break;

        case STATUS_IO:
             {
               fd_set readfds;
               FD_ZERO(&readfds);
               FD_SET(sock[i], &readfds);

               timeval to = {0,0};

               res = select(sock[i], &readfds, NULL, NULL, &to);

               if (res == -1)
               {
                 idle = 0;

                 //printf("killed io %d\n", i);

                 my_close_socket(i);
                 break;
               } // res == -1

               if (res == 1)
               {
                 idle = 0;

                 static char temp[4096+1];
                 int res = recv(sock[i], temp, sizeof(temp)-1, MSG_NOSIGNAL);
                 if ((res == 0) || (res == -1))
                 {
                   //printf("killed io %d\n", i);

                   my_close_socket(i);
                   break;
                 }

                 //printf("received %d bytes from %d\n", res, i);

                 j = lnk[i];
                 if (j != -1)
                 {
                   if (j == -2)
                   {
                     control(i, temp, res);
                   }
                   else
                   {
                     res = send(sock[j], temp, res, MSG_NOSIGNAL);
                     if ((res == 0) || (res == -1))
                     {
                       //printf("killed io %d\n", j);

                       my_close_socket(j);
                       break;
                     }

                     //printf("sent %d bytes from %d to %d\n", i, j);
                   }
                 }
               } // res == 1

             }
             break;

      } // switch(status[i])

    } // for i -- for each socket

    if (idle)
    {
#ifdef WIN32
      Sleep(10);
#endif
#ifdef LINUX
      usleep(10*1000);
#endif
    }

  } // for(;;) -- main cycle

#ifdef WIN32
  WSACleanup();
#endif

  return 0;
} // main

// [EOF]
