
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <time.h>
#include <io.h>
#pragma hdrstop

                         // nrv2b def.
int _P1[2]={0,8};        //   2        limit: 0..?
int _P2[2]={0,12};       //   8        limit: 0..?
int _P3[2]={0,8};        //   0        limit: 0..?
int _P4[2]={0,3};        //   3        limit: 0..3
int _P5[2]={0,1};        //   0        limit: 0..1

int P1,P2,P3,P4,P5;

#pragma optimize("g",on)

#define bbPutBit(x)                             \
{                                               \
  if (t_bitcount == 32)                         \
  {                                             \
    t_bitset   = (DWORD*)t_outptr;              \
    t_outptr += 4;                              \
    *t_bitset  = 0;                             \
    t_bitcount = 0;                             \
  }                                             \
  *t_bitset = ((*t_bitset) << 1) | ((x)&1);     \
  t_bitcount++;                                 \
}

#define code_prefix_ss11(a)                     \
{                                               \
    DWORD i = a;                                \
    if (i >= 2)                                 \
    {                                           \
        DWORD t = 4;                            \
        i += 2;                                 \
        do {                                    \
            t <<= 1;                            \
        } while (i >= t);                       \
        t >>= 1;                                \
        do {                                    \
            t >>= 1;                            \
            bbPutBit((i & t) ? 1 : 0);          \
            bbPutBit(0);                        \
        } while (t > 2);                        \
    }                                           \
    bbPutBit(i & 1);                            \
    bbPutBit(1);                                \
}

#define code_prefix_ss12(a)                     \
{                                               \
    DWORD i = a;                                \
    if (i >= 2)                                 \
    {                                           \
        DWORD t = 2;                            \
        do {                                    \
            i -= t;                             \
            t <<= 2;                            \
        } while (i >= t);                       \
        do {                                    \
            t >>= 1;                            \
            bbPutBit((i & t) ? 1 : 0);          \
            bbPutBit(0);                        \
            t >>= 1;                            \
            bbPutBit((i & t) ? 1 : 0);          \
        } while (t > 2);                        \
    }                                           \
    bbPutBit(i & 1);                            \
    bbPutBit(1);                                \
}

DWORD* ss11_len;
DWORD* ss12_len;
BYTE*  mem1;
BYTE*  mem2;
DWORD*c_hash_max;
DWORD*c_hash_cnt;
DWORD**c_hash_ptr;
DWORD*c_off;
DWORD*c_len;
DWORD*c_pak;
DWORD*c_lmo;
DWORD*c_prv;
DWORD*c_nxt;

void pack_init(BYTE* inptr, DWORD ilen)
{
  ss11_len = (DWORD*)malloc((ilen+1)*4);
  ss12_len = (DWORD*)malloc((ilen+1)*4);
  for(DWORD q=0; q<=ilen; q++)
  {
    //
    DWORD i = q;
    int r = 0;
    if (i >= 2)
    {
      DWORD t = 4;
      i += 2;
      do {
        t <<= 1;
      } while (i >= t);
      t >>= 1;
      do {
        t >>= 1;
        r += 2;
      } while (t > 2);
    }
    ss11_len[q] = r+2;
    //
    i = q;
    r = 0;
    if (i >= 2)
    {
      DWORD t = 2;
      do {
        i -= t;
        t <<= 2;
      } while (i >= t);
      do {
        t >>= 2;
        r += 3;
      } while (t > 2);
    }
    ss12_len[q] = r+2;
  }

  DWORD sz = (ilen+1) << 2;

  mem1 = (BYTE*)malloc(sz*6);

  c_off = (DWORD*)(mem1);
  c_len = (DWORD*)(mem1+sz);
  c_pak = (DWORD*)(mem1+sz*2);
  c_lmo = (DWORD*)(mem1+sz*3);
  c_prv = (DWORD*)(mem1+sz*4);
  c_nxt = (DWORD*)(mem1+sz*5);

  mem2 = (BYTE*)malloc(65536*4*3);
  memset(mem2, 0x00, 65536*4*3);

  c_hash_max = (DWORD*)(mem2);
  c_hash_cnt = (DWORD*)(mem2+65536*4*1);
  c_hash_ptr = (DWORD**)(mem2+65536*4*2);

  for(int i=0; i<ilen-1; i++)
  {
    DWORD w = *(WORD*)&inptr[i];
    if (c_hash_cnt[w] == c_hash_max[w])
    {
      if (c_hash_max[w] == 0)
        c_hash_max[w] = 1024;
      else
        c_hash_max[w] <<= 1;
      DWORD* newptr = (DWORD*)malloc(c_hash_max[w] << 2);
      if (c_hash_ptr[w] != NULL)
      {
        memcpy(newptr, c_hash_ptr[w], c_hash_cnt[w] << 2);
        free(c_hash_ptr[w]);
      }
      c_hash_ptr[w] = newptr;
    }
    c_hash_ptr[w][c_hash_cnt[w]++] = i;
  }

} // pack_init

DWORD pack( BYTE* inptr,
            DWORD ilen,
            BYTE* outptr,
            int   build )
{
  BYTE*  t_outptr;
  DWORD* t_bitset;
  DWORD  t_bitcount;
  BYTE*  inptr_0 = inptr;

  DWORD sz = (ilen+1) << 2;
  memset(mem1, 0x00, sz*6);

  c_lmo[0] = 1;

  // xxxxxxxxx

  for(DWORD i=0; i<ilen; i++)
  {

#define FOLLOW(src,dst,bitpaklen,lmo,off,len)                                 \
        {                                                                     \
          int n = c_pak[src] + (bitpaklen);                                   \
          if ( (c_pak[dst] == 0) ||                                           \
               (  c_pak[dst] > n )  )                                         \
          {                                                                   \
            c_pak[dst] = n;                                                   \
            c_lmo[dst] = lmo;                                                 \
            c_off[dst] = off;                                                 \
            c_len[dst] = len;                                                 \
            c_prv[dst] = src;                                                 \
          }                                                                   \
        }

    FOLLOW(i,i+1,9,c_lmo[i],0,0)

    if (i < ilen-1)
    {
      WORD w = *(WORD*)&inptr[i];
      DWORD cnt = c_hash_cnt[w];
      for(int c=0; c<cnt; c++)
      {
        int z = c_hash_ptr[w][c];
        if (z >= i) break;
        DWORD t_off = i - z;
        DWORD t_len = 1;
        while((i+t_len<ilen)&&(inptr[i+t_len] == inptr[z+t_len]))
        {
          t_len++;

          if ((P1==0)||(((t_len > 2) || ((t_len == 2) && (t_off <= (P4&1?0xd00:0x500))))))
          {

            int l;
            l = 1;
            if (t_off == c_lmo[i])
              l += 2;
            else
            {
              if (P4&1)
                l += ss11_len[1 + ((t_off - (P5?1:0)) >> P2)];
              else
                l += ss12_len[1 + ((t_off - (P5?1:0)) >> P2)];
              l += P2;
            }
            int t = t_len - 1 - (t_off > (P4&1?0xd00:0x500));
            if ((P1 != 0)&&(t < (1<<P1)))
              l += P1;
            else
            {
              l += P1 + P3;

              if (P4&2)
                l += ss11_len[(t - (1<<P1)) >> P3];
              else
                l += ss12_len[(t - (1<<P1)) >> P3];
            }

            if (l < (t_len << 3))
              FOLLOW(i,i+t_len,l,t_off, t_off,t_len)
          }

        }

      }
    }

  }

  // yyyyyyyy

  DWORD x = ilen;
  for(;;)
  {
    DWORD y = c_prv[x];
    c_nxt[y] = x;
    x = y;
    if (x == 0) break;
  }

  t_outptr   = outptr;

  *t_outptr++ = *inptr++;

  t_bitset   = (DWORD*)t_outptr;
  t_outptr   += 4;
  *t_bitset  = 0;
  t_bitcount = 0;

  DWORD last_m_off = 1;

  x = 0;
  while(1)
  {
    DWORD y = c_nxt[x];
    if (y == 0) break;

    DWORD m_off = c_off[y];
    DWORD m_len = c_len[y];

    if (m_len == 0)
    {
      if (x != 0)
      {
        bbPutBit(1);
        *t_outptr++ = *inptr++;
      }
      //ilen--;
    }
    else
    {
      inptr += m_len;
      //ilen  -= m_len;

      m_len = m_len - 1 - (m_off > (P4&1?0xd00:0x500));
      //
      bbPutBit(0);
      if (m_off == last_m_off)
      {
          bbPutBit(0);
          bbPutBit(1);
      }
      else
      {
          last_m_off  = m_off;

          if (P5) m_off--;

          if (P4&1)
            code_prefix_ss11(1 + (m_off >> P2))
          else
            code_prefix_ss12(1 + (m_off >> P2));
          if (P2==8)
            *t_outptr++ = m_off;
          else
          for(int k=0; k<P2; k++)
            bbPutBit(m_off >> (P2-k-1));
      }
      if ((P1!=0)&&(m_len < (1<<P1)))
      {
          assert(m_len!=0);
          for(int k=0; k<P1; k++)
            bbPutBit(m_len >> (P1-k-1));
      }
      else
      {
          for(int k=0; k<P1; k++)
            bbPutBit(0);
          m_len -= 1<<P1;
          //
          if (P4&2)
            code_prefix_ss11(m_len >> P3)
          else
            code_prefix_ss12(m_len >> P3);

          for(k=0; k<P3; k++)
            bbPutBit(m_len >> (P3-k-1));
      }
      //

    }

    x = y;
  }


  bbPutBit(0);
  DWORD m_off=0;
  if (P5) m_off--;
  if (P4&1)
    code_prefix_ss11(1 + (m_off >> P2))
  else
    code_prefix_ss12(1 + (m_off >> P2));
  if (P2==8)
    *t_outptr++ = m_off;
  else
  for(int k=0; k<P2; k++)
    bbPutBit(m_off >> (P2-k-1));

  while(t_bitcount != 32)
    bbPutBit(0);

  // build unpacker

  DWORD*x_value = new DWORD[1024];
  DWORD*x_type  = new DWORD[1024];      // 1=byte 2=label 3=R4 4=packed 5=R1
  DWORD*x_offs  = new DWORD[1024];
  BYTE* x_data  = new BYTE[t_outptr-outptr+1024];
  DWORD x_count = 0;


#define ADD_B(x)                       \
        {                              \
          x_value[x_count  ] = (x);    \
          x_type [x_count++] = 1;      \
        }
#define ADD_D(x)                       \
        {                              \
          ADD_B((x)&0xFF);             \
          ADD_B(((x)>>8)&0xFF);        \
          ADD_B(((x)>>16)&0xFF);       \
          ADD_B(((x)>>24)&0xFF);       \
        }
#define ADD_BB(x,y)                    \
        {                              \
          ADD_B(x);                    \
          ADD_B(y);                    \
        }
#define ADD_BBB(x,y,z)                 \
        {                              \
          ADD_B(x);                    \
          ADD_B(y);                    \
          ADD_B(z);                    \
        }
#define ADD_BBBB(x,y,z,w)              \
        {                              \
          ADD_B(x);                    \
          ADD_B(y);                    \
          ADD_B(z);                    \
          ADD_B(w);                    \
        }
#define ADD_BD(x,y)                    \
        {                              \
          ADD_B(x);                    \
          ADD_D(y);                    \
        }
#define ADD_BBD(x,y,z)                 \
        {                              \
          ADD_B(x);                    \
          ADD_B(y);                    \
          ADD_D(z);                    \
        }
#define ADD_L(x)                       \
        {                              \
          x_value[x_count  ] = (x);    \
          x_type [x_count++] = 2;      \
        }
#define ADD_BR4(x,y)                   \
        {                              \
          ADD_B(x);                    \
          ADD_R4(y);                   \
        }
#define ADD_BR1(x,y)                   \
        {                              \
          ADD_B(x);                    \
          ADD_R1(y);                   \
        }
#define ADD_R4(x)                      \
        {                              \
          x_value[x_count  ] = (x);    \
          x_type [x_count++] = 3;      \
        }
#define ADD_R1(x)                      \
        {                              \
          x_value[x_count  ] = (x);    \
          x_type [x_count++] = 5;      \
        }
#define ADD_P()                        \
        {                              \
          x_value[x_count  ] = (x);    \
          x_type [x_count++] = 4;      \
        }

  if (build)
  {
    ADD_BR4(0xE8, 0xFFFFFFF01);        // call    pop_packed
    ADD_P ();
    ADD_L (0xFFFFFF01);                // pop_packed:
    ADD_B (0x5E);                      // pop     esi
    ADD_BBD(0x81,0xEC,(ilen+3)&(~3));  // sub     esp, (unpacked_size+3) & 0xfffffffc
    ADD_BB(0x89,0xE7);                 // mov     edi, esp
  }
  else
  {
    ADD_B(0x60);                       // pusha
    ADD_BR4(0xE8, 0xFFFFFFF01);        // call    pop_packed
    ADD_P ();
    ADD_L (0xFFFFFF01);                // pop_packed:
    ADD_B (0x5E);                      // pop     esi
    ADD_BD(0xBF, (DWORD)mem1);         // mov     edi, <mem1>
  }

  ADD_BB(0x6A,0xFF);                   // push    -1
  ADD_B(0x5D);                         // pop     ebp

  ADD_BR4(0xE8,0xFFFFFF02);            // call    __pop_getbit
  ADD_BB(0x01,0xDB);                   // add     ebx, ebx
  ADD_BR1(0x75,0xFFFFFF03);            // jnz     __x1
  ADD_BB(0x8B,0x1E);                   // mov     ebx, [esi]
  ADD_BBB(0x83,0xee,0xfc);             // sub     esi, -4
  ADD_BB(0x13,0xDB);                   // adc     ebx, ebx
  ADD_L(0xFFFFFF03);                   // __x1:
  ADD_B(0xC3);                         // retn
  ADD_L(0xFFFFFF02);                   // __pop_getbit:

  ADD_BB(0x31,0xDB);                   // xor     ebx, ebx

  ADD_L(0xFFFFFF06);                   // __decompr_literals_n2b:
  ADD_B(0xA4);                         // movsb
  ADD_L(0xFFFFFF07);                   // __decompr_loop_n2b:
  ADD_BBB(0xFF,0x14,0x24);             // call    dword ptr [esp] ; getbit
  ADD_BR1(0x72,0xFFFFFF06);            // jc      __decompr_literals_n2b

  ADD_BB(0x33,0xC0);                   // xor     eax, eax
  ADD_B(0x40);                         // inc     eax
  ADD_L(0xFFFFFF0A);                   // __loop1_n2b:
  if (P4&1) // s11
  {
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC0);                 // adc     eax, eax
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BR1(0x73,0xFFFFFF0A);          // jnc     __loop1_n2b
  }
  else // s12
  {
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC0);                 // adc     eax, eax
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BR1(0x72,0xFFFFFF1A);          // jc      __loopend1_n2d
    ADD_B(0x48);                       // dec     eax
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC0);                 // adc     eax, eax
    ADD_BR1(0xEB,0xFFFFFF0A);          // jmp     __loop1_n2b
    ADD_L(0xFFFFFF1A);                 // __loopend1_n2d:
  }

  ADD_BB(0x31,0xC9);                   // xor     ecx, ecx

  ADD_BBB(0x83,0xE8,0x03);             // sub     eax, 3
  ADD_BR1(0x72,0xFFFFFF0B);            // jc     __decompr_ebpeax_n2b

  if (P2==0)
  {
  }
  else
  if (P2==1)
  {
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC0);                 // adc     eax, eax
  }
  else
  if (P2==8)
  {
    ADD_BBB(0xC1,0xE0,0x08);           // shl     eax, 8
    ADD_B(0xAC);                       // lodsb
  }
  else
  {
    ADD_BB(0xB1,P2);                   // mov     cl, P2
    ADD_L(0xFFFFFF0D);                 // __q1:
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC0);                 // adc     eax, eax
    ADD_BR1(0xE2,0xFFFFFF0D);          // loop    __q1
  }

  if (!P5)
  {
    ADD_B(0x48);                       // dec     eax
  }

  ADD_BBB(0x83,0xF0,0xFF);             // xor     eax, -1
  ADD_BR1(0x74,0xFFFFFF08);            // jz     __decompr_end_n2b

  ADD_B(0x95);                         // xchg    ebp, eax

  ADD_L(0xFFFFFF0B);                   // __decompr_ebpeax_n2b:

  if (P1==0)
  {
  }
  else
  if (P1==1)
  {
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC9);                 // adc     ecx, ecx
    ADD_BR1(0x75,0xFFFFFF09);          // jnz     __decompr_got_mlen_n2b
  }
  else
  if (P1==2)
  {
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC9);                 // adc     ecx, ecx
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC9);                 // adc     ecx, ecx
    ADD_BR1(0x75,0xFFFFFF09);          // jnz     __decompr_got_mlen_n2b
  }
  else
  {
    ADD_BB(0x33,0xC0);                 // xor     eax, eax
    ADD_BB(0xB1,P1);                   // mov     cl, P1
    ADD_L(0xFFFFFF0E);                 // __q2:
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC0);                 // adc     eax, eax
    ADD_BR1(0xE2,0xFFFFFF0E);          // loop    __q2
    ADD_BB(0x01,0xC1);                 // add     ecx, eax
    ADD_BR1(0x75,0xFFFFFF09);          // jnz     __decompr_got_mlen_n2b
  }

  ADD_B(0x41);                         // inc     ecx
  ADD_L(0xFFFFFF0C);                   // __loop2_n2b:
  if (P4&2) // s11
  {
    ADD_BBB(0xFF,0x14,0x24);             // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC9);                   // adc     ecx, ecx
    ADD_BBB(0xFF,0x14,0x24);             // call    dword ptr [esp] ; getbit
    ADD_BR1(0x73,0xFFFFFF0C);            // jnc     __loop2_n2b
  }
  else
  {
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC9);                 // adc     ecx, ecx
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BR1(0x72,0xFFFFFF1B);          // jc      __loop2end
    ADD_B(0x49);                       // dec     ecx
    ADD_BBB(0xFF,0x14,0x24);           // call    dword ptr [esp] ; getbit
    ADD_BB(0x11,0xC9);                 // adc     ecx, ecx
    ADD_BR1(0xEB,0xFFFFFF0C);          // jmp     __loop2_n2b
    ADD_L(0xFFFFFF1B);                 // __loop2end:
  }

  if (P3)
  {
    ADD_B(0x49);                       // dec     ecx
    ADD_B(0x49);                       // dec     ecx

    if (P3==1)
    {
      ADD_BBB(0xFF,0x14,0x24);         // call    dword ptr [esp] ; getbit
      ADD_BB(0x11,0xC9);               // adc     ecx, ecx
    }
    else
    if (P3==2)
    {
      ADD_BBB(0xFF,0x14,0x24);         // call    dword ptr [esp] ; getbit
      ADD_BB(0x11,0xC9);               // adc     ecx, ecx
      ADD_BBB(0xFF,0x14,0x24);         // call    dword ptr [esp] ; getbit
      ADD_BB(0x11,0xC9);               // adc     ecx, ecx
    }
    else // P3 >= 3
    {
      ADD_BB(0x6A,P3);                 // push    P3
      ADD_B(0x58);                     // pop     eax
      ADD_L(0xFFFFFF0F);               // __q3:
      ADD_BBB(0xFF,0x14,0x24);         // call    dword ptr [esp] ; getbit
      ADD_BB(0x11,0xC9);               // adc     ecx, ecx
      ADD_B(0x48);                     // dec     eax
      ADD_BR1(0x75,0xFFFFFF0F);        // jnz     __q3
    }

    if (P1==0)
    {
      ADD_B(0x41);                     // inc     ecx
    }
    else
    if (P1==1)
    {
      ADD_B(0x41);                     // inc     ecx
      ADD_B(0x41);                     // inc     ecx
    }
    else // P1>=2
    if (P1<=6)
    {
      ADD_BBB(0x83,0xC1,(1<<P1));      // add     ecx, (1<<P1)
    }
    else // P1>=7
    {
      ADD_BBD(0x81,0xC1,(1<<P1));      // add     ecx, (1<<P1)
    }
  }
  else
  {
    if (P1==0)
    {
      ADD_B(0x49);                     // dec     ecx
    }
    else
    if (P1==1)
    {
    }
    else
    if (P1==2)
    {
      ADD_B(0x41);                     // inc     ecx
      ADD_B(0x41);                     // inc     ecx
    }
    else // P1=3..7
    if (P1<=7)
    {
      ADD_BBB(0x83,0xC1,(1<<P1)-2);    // add     ecx, (1<<P1)
    }
    else // P1>=8
    {
      ADD_BBD(0x81,0xC1,(1<<P1)-2);      // add     ecx, (1<<P1)
    }
  }

  ADD_L(0xFFFFFF09);                   // __decompr_got_mlen_n2b:
  ADD_BBD(0x81,0xFD,((P4&1?-0xd00:-0x500)));   // cmp     ebp, -0?00h
  ADD_BBB(0x83,0xD1,0x01);             // adc     ecx, 1
  ADD_B(0x56);                         // push    esi
  ADD_BBB(0x8d,0x34,0x2f);             // lea     esi, [edi+ebp]
  ADD_BB(0xf3,0xa4);                   // rep     movsb
  ADD_B(0x5E);                         // pop     esi
  ADD_BR1(0xEB,0xFFFFFF07);            // jmp     __decompr_loop_n2b

  ADD_L(0xFFFFFF08);                   // __decompr_end_n2b:

  ADD_B(0x59);                         // pop     ecx     ; free ptr to getbit

  if (build)
  {
    ADD_BB(0xFF,0xE4);                 // jmp     esp
  }
  else
  {
    ADD_BBBB(0x89,0x7c,0x24,0x1c);     // mov     [esp+28], edi
    ADD_B(0x61);                       // popa
    ADD_B(0xC3);                       // retn
  }

  // link -- pass 1/2 -- build code

  int x_len = 0;
  for(i=0; i<x_count; i++)
  {
    if (x_type[i]==4) // packed
    {
      memcpy(x_data+x_len,outptr,t_outptr-outptr);
      x_len += t_outptr-outptr;
    }
    else
    if ((x_type[i]==1)||(x_type[i]==5))  // BYTE or R1
    {
      x_offs[i] = x_len;
      x_data[x_len++] = x_value[i];
    }
    else
    if (x_type[i]==3)   // R4
    {
      x_offs[i] = x_len;
      x_len += 4;
    }
    else
    if (x_type[i]==2) // LABEL
    {
      x_offs[i] = x_len;
    }
  }

  // link -- pass 2/2 -- fix rel. jmps

  for(i=0; i<x_count; i++)
  {
    DWORD dst=0;
    if ((x_type[i]==5)||(x_type[i]==3)) // R1,R4
    {
      for(int j=0; j<x_count; j++)
        if (x_type[j]==2) // LABEL
        if (x_value[j]==x_value[i])
        {
          dst=x_offs[j];
          break;
        }
      assert(dst);
    }
    if (x_type[i]==5) // R1
      x_data[x_offs[i]] = dst - (x_offs[i]+1);
    else
    if (x_type[i]==3) // R4
      *(DWORD*)&x_data[x_offs[i]] = dst - (x_offs[i]+4);
  }

  if (!build)
  {
    // call generated unpacker && verify unpacked data
    typedef DWORD (__cdecl* functype)(void);
    memset(mem1,0,ilen);
    DWORD mem1_len = ((functype)x_data)() - (DWORD)mem1;
    if (mem1_len != ilen)
    {
      printf("verify SIZE error (got %d,need %d)\n",mem1_len,ilen);
      exit(0);
    }
    if (memcmp(inptr_0, mem1, ilen) != 0)
    {
      printf("verify DATA error\n");
      exit(0);
    }
  }

  memcpy(outptr, x_data, x_len);

  delete x_value;
  delete x_type;
  delete x_offs;
  delete x_data;

  //

  return x_len;

} // pack

void pack_done()
{
  for(int i=0; i<65536; i++)
    if (c_hash_ptr[i])
      free(c_hash_ptr[i]);
  free(mem1);
  free(mem2);

  free(ss11_len);
  free(ss12_len);
} // pack_done

void main(int argc, char* argv[])
{
  printf("upx for code snippets (x86,32-bit)  v1.00s  (x) 2004\n");

  if (argc!=4)
  {
    printf("syntax:\n");
    printf("  snippetupxs p infile outfile\n");
    exit(0);
  }
  assert(!stricmp(argv[1], "p"));
  char* infile  = argv[2];
  char* outfile = argv[3];

  FILE*f1=fopen(infile,"rb");
  int ilen = filelength(fileno(f1));
  BYTE* ibuf = new BYTE[ ilen ];
  fread(ibuf,1,ilen,f1);
  fclose(f1);

  BYTE* obuf = new BYTE[ ilen+(ilen>>3)+1024 ];
  BYTE* xbuf = new BYTE[ ilen+1024 ];
  DWORD olen=0, xlen=0;

  int min_olen = -1;
  int min_P1;
  int min_P2;
  int min_P3;
  int min_P4;
  int min_P5;

  pack_init(ibuf,ilen);

  for(P1=_P1[0]; P1<=_P1[1]; P1++)
  for(P2=_P2[0]; P2<=_P2[1]; P2++)
  for(P3=_P3[0]; P3<=_P3[1]; P3++)
  for(P4=_P4[0]; P4<=_P4[1]; P4++)
  for(P5=_P5[0]; P5<=_P5[1]; P5++)
  {

    if (P5 && (P2<=1)) continue; // incompatible options

    printf("P1=%d,P2=%d,P3=%d,P4=%d,P5=%d, ", P1,P2,P3,P4,P5);
    DWORD t0 = GetTickCount();
    olen = pack(ibuf,ilen,obuf,0);
    DWORD t1 = GetTickCount();
    printf("%d --> %d, %d ms\n", ilen, olen, t1-t0);

    if ((min_olen == -1) || (min_olen > olen))
    {
      min_olen = olen;
      min_P1   = P1;
      min_P2   = P2;
      min_P3   = P3;
      min_P4   = P4;
      min_P5   = P5;
      printf(".best\n");
    }
  }

  P1 = min_P1;
  P2 = min_P2;
  P3 = min_P3;
  P4 = min_P4;
  P5 = min_P5;

  printf("packing best...\n");
  DWORD t0 = GetTickCount();
  olen = pack(ibuf,ilen,obuf,1);
  DWORD t1 = GetTickCount();
  printf("P1=%d,P2=%d,P3=%d,P4=%d,P5=%d, %d --> %d, %d ms\n", P1,P2,P3,P4,P5, ilen, olen, t1-t0);

  pack_done();

  FILE*f2=fopen(outfile,"wb");
  fwrite(obuf,1,olen,f2);
  fclose(f2);

  delete ibuf;
  delete obuf;
  delete xbuf;

} // main
