
/*
  This file describes CT2HList class,
  which is used to track Thread_ID <--> Thread_Handle relations.
  This is so, because fucking stupid win32 has both tid and handle,
  but there is no standard methods to convert it there and back.
  Also, variables, specific for each thread are described here.
*/

#define LOG_T2H

struct t2h_struct : CListEntry
{
  DWORD  tid;                   // thread ID
  HANDLE handle;                // thread HANDLE
  DWORD  id;                    // thread # (in order of creation while trace)
  DWORD  l_index;               // # of instructions executed per this thread
  DWORD  prev_ins;              // VA of last executed instruction
};

class CT2HList : public CList
{
  public:
  DWORD id;
  CT2HList() : CList( sizeof(t2h_struct) ) { id = 0; }
  t2h_struct* FindByTID(DWORD tid);
  int Add(DWORD tid, HANDLE handle);
  int Del(DWORD tid);
}; // class CT2HList

t2h_struct* CT2HList::FindByTID(DWORD tid)
{
  t2h_struct* t;
  ForEach(t2h_struct, t)
    if (t->tid == tid)
      return t;
  return NULL;
} // CT2HList::t2h_FindByTID()

int CT2HList::Add(DWORD tid, HANDLE handle)
{
  if (FindByTID(tid) != NULL)
  {
#ifdef LOG_T2H
    log("ERROR: CT2HList::Add(tid=%08X,handle=%08X): tid alredy in list\n", tid, handle);
#endif
    return 0;
  }

  t2h_struct* t = (t2h_struct*) Alloc();
  if (t == NULL)
  {
#ifdef LOG_T2H
    log("ERROR: CT2HList::Add(tid=%08X,handle=%08X): cant allocate t2h_struct\n", tid, handle);
#endif
    return 0;
  }

  t->tid    = tid;
  t->handle = handle;
  t->id     = ++id;

  Attach(t);

  return 1;
} // CT2HList::Add()

int CT2HList::Del(DWORD tid)
{
  t2h_struct* t = FindByTID(tid);
  if (t == NULL)
  {
#ifdef LOG_T2H
    log("ERROR: CT2HList::Del(tid=%08X): tid not found\n", tid);
#endif
    return 0;
  }

  Detach( (void*)t );
  Free  ( (void*)t );

  return 1;
} // CT2HList::Del()
