
; CODEGEN 2.xx usage example
;
; ACTION:
; produce code which will calculate an expression: c := a xor b;
; where a, b and c are DWORD-vars.

include                 ..\..\CODEGEN\asm\cg_bin.ash

callW                   macro   x
                        extern  x:PROC
                        call    x
                        endm

                        p386
                        model   flat
                        locals  __

                        .data

randseed                dd      ?

buf_size                dd      ?               ; resulting code size
buf                     db      8192 dup (0)    ; resulting code

a                       dd      1               ; a
b                       dd      2               ; b
c                       dd      ?               ; c = a xor b

tempdd                  dd      ?

etgsize                 dd      ?            ; size of trash generated by ETG

                        .code

start:
                        callW   GetTickCount    ; randomize
                        xor     randseed, eax
;                       mov     randseed, 12345678h

                        lea     edi, buf

                        ; c = a
                        push    offset a
                        push    offset c
                        push    cmd_mov
                        push    cmd_v_v
                        call    call_codegen

                        ; c ^= b
                        push    offset b
                        push    offset c
                        push    cmd_xor
                        push    cmd_v_v
                        call    call_codegen

                        mov     al, 0C3h        ; ret
                        stosb

                        sub     edi, offset buf  ; calc buf size
                        mov     buf_size, edi

                        call    my_random
                        mov     eax, randseed
                        mov     a, eax
                        call    my_random
                        mov     eax, randseed
                        mov     b, eax
                        call    my_random
                        mov     eax, randseed
                        mov     c, eax

                        int 3

                        call    near ptr buf    ; call generated code

                        mov     eax, a          ; check if (c == a ^ b)
                        xor     eax, b
                        cmp     eax, c
                        jne     $               ; hangup if error

                        push    -1              ; exit 2 md
                        callW   ExitProcess

; called after each instruction is stored

my_trash:               pusha
                        mov     edi, [esp+32+8]    ; outptr
                        mov     ecx, [esp+32+12]    ; regfree

;                       mov     al, 90h
;                       stosb

                        push    offset my_random; external subroutine: rnd
                        push    edi             ; ptr to output buffer
                        push    1024            ; max size of buffer
                        push    3               ; max number of commands
                        push    offset etgsize  ; ptr to generated bufsize
                        push    ecx ; regfree   ; REG_xxx (dest)
                        push    REG_ALL         ; REG_xxx (src)
                        push    ETG_ALL-ETG_SEG ; ETG_xxx (cmd)
                        push    12345678h       ; user_param
                        call    etg_engine
                        add     esp, 9*4
                        add     edi, etgsize

;                       mov     al, 90h
;                       stosb

                        mov     [esp+7*4], edi  ; popa.eax <-- edi
                        popa
                        retn

my_fixup:               pusha
                        mov     edi, [esp+32+8]    ; outptr
                        mov     eax, [esp+32+12]   ; fixup's value
                        stosd
                        mov     [esp+7*4], edi  ; popa.eax <-- edi
                        popa
                        retn

call_codegen:           mov     eax, [esp+4]
                        mov     ebx, [esp+8]
                        mov     ecx, [esp+12]
                        mov     edx, [esp+16]
                        push    edx                     ; x4
                        push    ecx                     ; x3
                        push    ebx                     ; x2
                        push    eax                     ; x1
                        push    offset my_random        ; random()
                        push    offset my_trash         ; trash()
                        push    offset my_fixup         ; fixup()
                        call    my_random
                        push    11001111b               ; regfree
                        push    offset tempdd           ; outbufsize
                        push    edi                     ; bufptr
                        push    12345678h               ; userdata
                        call    codegen
                        add     esp, 11*4
                        add     edi, tempdd
                        retn    4*4

; DWORD __cdecl random(DWORD userdata, DWORD range)
;                       [esp+4]        [esp+8]
my_random:              mov     eax, randseed
                        imul    eax, 214013
                        add     eax, 2531011
                        mov     randseed, eax
                        shr     eax, 16
                        imul    eax, [esp+8]
                        shr     eax, 16
                        retn

include                 etg.inc                 ; ETG

codegen:
include                 ..\..\CODEGEN\asm\cg_bin.inc  ; CODEGEN

                        end     start
