
;----------------------------------------------------------------------------
; RSA-encryption library (128-bit)            (x) 2000 Z0MBiE, z0mbie.cjb.net
;----------------------------------------------------------------------------

; version 5.00

; * fixed precision (128-bit)
; * fixed exponent (e = 3)
; * small code, slow -- use for signature verification

;----------------------------------------------------------------------------

; action: *EDI = (*EDI ^ 3) % *ESI
; input:  *EDI = base = result
;         *ESI = modulus

modexp5:                pusha
                        mov     eax, [edi]     ; dcba = [EDI]
                        mov     ebx, [edi+4]
                        mov     ecx, [edi+8]
                        mov     edx, [edi+12]
                        call    __modmul       ; dcba = (dcba * [EDI]) % [ESI]
                        call    __modmul       ; dcba = (dcba * [EDI]) % [ESI]
                        stosd                  ; [EDI] = dcba
                        xchg    ebx, eax
                        stosd
                        xchg    ecx, eax
                        stosd
                        xchg    edx, eax
                        stosd
                        popa
                        retn
; action: dcba = (dcba * [EDI]) % [ESI]
__modmul:               pusha
                        xor     eax, eax       ; dcba = 0
                        xor     ebx, ebx
                        xor     ecx, ecx
                        xor     edx, edx
                        push    127            ; cycle: EBP = 127 downto 0
                        pop     ebp            ;
__mul_cycle:            xor     edi, edi       ; CF=0
                        shl     eax, 1         ; dcba <<= 1
                        rcl     ebx, 1
                        rcl     ecx, 1
                        rcl     edx, 1
                        rcl     edi, 1         ; CF<--
                        call    __cmpsub       ; if (dcba>=[ESI]) dcba-=[ESI]
                        mov     edi, [esp+0*4] ; pusha.edi
                        bt      [edi], ebp     ; if [EDI].bit[EBP]==1
                        jnc     __mul_skip
                        xor     edi, edi       ; CF=0
                        add     eax, [esp+7*4] ; pusha.eax
                        adc     ebx, [esp+4*4] ; pusha.ebx
                        adc     ecx, [esp+6*4] ; pusha.ecx
                        adc     edx, [esp+5*4] ; pusha.edx
                        adc     edi, 0         ; CF<--
                        call    __cmpsub       ; if (dcba>=[ESI]) dcba-=[ESI]
__mul_skip:             dec     ebp            ; cycle
                        jns     __mul_cycle
                        pop     edi            ; restore EDI/ESI after PUSHA
                        pop     esi
                        push    ecx
                        push    ecx
__rt:                   add     esp, 32
                        retn
; action: if (dcba >= [ESI]) { dcba -= [ESI] }
__cmpsub:               pusha
                        mov     esi, [esp+32+4+1*4]  ; pusha.esi
                        sub     eax, [esi]     ; dcba -= [ESI]
                        sbb     ebx, [esi+4]
                        sbb     ecx, [esi+8]
                        sbb     edx, [esi+12]
                        sbb     edi, 0         ; CF
                        jnc     __rt
                        popa                   ; CF==1 -- return unchanged
                        retn

;----------------------------------------------------------------------------
