{ screen saver }
{ (x) http://z0mbie.cjb.net }

uses crt;

const
  rx    = 64;
  ry    = 64;

  NNc   = 3;

  kk    = 2;

  krx   = rx*2-2;
  kry   = ry*2-2;

type
  t1 = array[-ry..ry,-rx..rx] of integer;
  t2 = array[-ry..ry,-rx..rx] of byte;

const
  DISP : integer = 0;

var
  NN : integer;
  video : array[0..25-1,0..80-1] of record c,a:byte end;
  wx, wy: integer;
  palt  : array[byte] of record r,g,b:byte end;
  pal   : array[byte] of record b,g,r,x:byte end;
  clr   : array[0..15] of byte;
  font  : array[byte] of array[0..15] of byte;
  page  : word;
  lx, ly: array[1..NNc] of integer;
  dx, dy: array[1..NNc] of integer;
  lensex,
  lensey: ^t1;
  lensec: ^t2;
  cc    : integer;

procedure putpixel(x,y,c:integer);
  begin
    asm
      mov     ax, y
      xor     dx, dx
      mov     cx, 640
      mul     cx
      add     ax, x
      adc     dx, 0

      shl     ax, 1
      rcl     dx, 1
      shl     ax, 1
      rcl     dx, 1

      mov     di, ax

      cmp     dx, page
      je      @@1
      mov     page, dx

      mov     ax, 4f05h
      mov     bh, 00h
      int     10h

@@1:  mov     ax, 0a000h
      mov     es, ax

      mov     si, c
      and     si, 15
      xor     bx, bx
      mov     bl, byte ptr clr[si]
      add     bx, cc
      shl     bx, 2

      lea     si, pal[bx]
      db      66h
      movsw

    end;
  end;

procedure redraw(x0,y0,x1,y1:integer);
  var
    n, ix,iy, tx,ty, kx,ky, x,y, i,j, c,a, t : integer;
  begin
    for iy := y0 to y1 do
    for ix := x0 to x1 do
    begin

      cc := 0;
      for n := 1 to NN do
      if (ix >= lx[n]-rx) and (ix <= lx[n]+rx) and
         (iy >= ly[n]-ry) and (iy <= ly[n]+ry) then
      begin
        cc := lensec^[iy-ly[n], ix-lx[n]];
        tx := lx[n] + lensex^[iy-ly[n], ix-lx[n]];
        ty := ly[n] + lensey^[iy-ly[n], ix-lx[n]];
        tx := (tx + 640*2) mod 640;
        ty := (ty + 480*2) mod 480;
        break;
      end;
      if cc=0 then
      begin
        tx := ix;
        ty := iy;
      end;

      ty := round(ty / 480 * 400);

      x := tx shr 3;
      y := ty shr 4;
      j := tx and 7;
      i := ty and 15;

      c := video[y,x].c;
      a := video[y,x].a;

      if (font[c][i] shr (7-j)) and 1 <> 0 then
        t := a and 15
      else
        t := a shr  4;
{
      if cc=0 then
        if odd(ix+iy) then
          t := 0;
}
      putpixel(ix,iy, t);
    end;
  end;

procedure init_lense;
  var
    x, y : integer;
    px, py, r, a : real;
  begin

    for x := -rx to rx do
    for y := -ry to ry do
    begin
      lensex^[y,x] := x;
      lensey^[y,x] := y;
      lensec^[y,x] := 0;
    end;

    for x := -(rx-kk) to rx-kk do
    for y := -(ry-kk) to ry-kk do
    begin

      px := x/(rx-kk);
      py := y/(ry-kk);
      r := sqrt(sqr(px) + sqr(py));

      if r<=1 then
      begin

        if px = 0 then begin
          if py>0 then a := pi/2;
          if py=0 then a := 0;
          if py<0 then a := pi/2*3;
        end else begin
          if py=0 then begin
            if px>=0 then a := 0 else a := pi;
          end else begin
            a := arctan(abs(py/px));
            if px>0 then begin
              if py<0 then a := pi*2 - a;
            end else begin
              if py>0 then a := pi-a else
                           a := pi+a;
            end;
          end;
        end;

        r := r / cos(r);

        a := a+ DISP *pi/180;

        lensex^[y,x] := -round( r * cos(a) * (rx-kk) );
        lensey^[y,x] := -round( r * sin(a) * (ry-kk) );
        lensec^[y,x] := 64*3;

        if r<0.8 then
        lensec^[y,x] := 64*2;

        a := 360-a/pi*180;

        if a>100 then
        if a<200 then
        if r>0.5 then
        if r<  1 then
          lensec^[y,x] := 64*1;

      end;

    end;

  end;

procedure swp(var a,b:integer);
  begin
    a := a xor b;
    b := b xor a;
    a := a xor b;
  end;

procedure move_lense;
  var
    n, i, lx0,ly0 : integer;
  begin

    for n := 1 to NN do
    begin

      lx0 := lx[n];
      ly0 := ly[n];

      lx[n] := lx[n] + dx[n];
      ly[n] := ly[n] + dy[n];

      if lx[n] < rx then
      begin
        lx[n] := rx;
        dx[n] := -dx[n];
      end;
      if ly[n] < ry then
      begin
        ly[n] := ry;
        dy[n] := -dy[n];
      end;

      if lx[n] > 640-1-rx then
      begin
        lx[n] := 640-1-rx;
        dx[n] := -dx[n];
      end;
      if ly[n] > 480-1-ry then
      begin
        ly[n] := 480-1-ry;
        dy[n] := -dy[n];
      end;

      for i := 1 to NN do
      if i<>n then
      begin
        if abs(lx[n]-lx[i])<krx then
        if abs(ly[n]-ly[i])<kry then
        begin
          lx[n] := lx0;
          ly[n] := ly0;
          swp(dx[n], dx[i]);
          swp(dy[n], dy[i]);
        end;
      end;

    end;

  end;

label c1;

var
  t, i, j, n : integer;
  p60 : byte;

  mb1,mb2,mb3,
  mb1t,mb2t,mb3t : word;

begin
  randomize;

  NN := 1+random(NNc);

  getmem(lensex, sizeof(t1));
  getmem(lensey, sizeof(t1));
  getmem(lensec, sizeof(t2));

  init_lense;

  move(mem[segb800:0], video, sizeof(video));
  wx := wherex;
  wy := wherey;

  asm

    push    ds
    pop     es
    lea     di, clr
    cld
    xor     bl, bl
@@1:mov     ax, 1007h
    int     10h
    mov     al, bh
    stosb
    inc     bl
    cmp     bl, 16
    jb      @@1

    push    ds
    pop     es
    lea     di, palt
    cld
    mov     dx, 3c7h
    xor     al, al
    out     dx, al
    inc     dx
    inc     dx
    mov     cx, 256*3
    cld
    rep     insb

    push    bp
    push    ds
    push    es
    mov     ax, 1130h
    mov     bh, 06h
    int     10h
    push    es
    pop     ds
    mov     si, bp
    push    seg @data
    pop     es
    lea     di, font
    mov     cx, 256*16
    cld
    rep     movsb
    pop     es
    pop     ds
    pop     bp

    mov     ax, 4f02h
    mov     bx, 112h
    int     10h
    mov     page, 0

    mov     ax, 0000h
    int     33h
    mov     ax, 0003h
    int     33h
    mov     mb1, bx
    mov     mb2, cx
    mov     mb3, dx
  end;

  for j := 0 to 3 do
  for i := 0 to 63 do
  begin
    pal[j*64+i].r := palt[i].r*(255-(j-0)*52) div 63;
    pal[j*64+i].g := palt[i].g*(255-(j-0)*32) div 63;
    pal[j*64+i].b := palt[i].b*(255-(j-0)*12) div 63;
    pal[j*64+i].x := 0;
{
    if j=0 then
    begin
      pal[j*64+i].r := palt[j*64+i].r*128 div 63;
      pal[j*64+i].g := palt[j*64+i].g*128 div 63;
      pal[j*64+i].b := palt[j*64+i].b*128 div 63;
    end;
}
  end;

  for n := 1 to NN do
  begin
c1:
    lx[n] := random(640-rx*2)+rx;
    ly[n] := random(480-ry*2)+ry;
    for i := 1 to n-1 do
      if abs(lx[n]-lx[i])<krx then
      if abs(ly[n]-ly[i])<kry then
        goto c1;
    repeat
      dx[n] := random(kk+1)-random(kk+1);
    until dx[n]<>0;
    repeat
      dy[n] := random(kk+1)-random(kk+1);
    until dy[n]<>0;
  end;

  redraw(0,0,640-1,480-1);

  p60 := port[$60];

  repeat
    {
    t := (t + 1) mod 10000;
    if t mod 20 = 0 then
    begin
      DISP := (DISP + 360-1) mod 360;
      init_lense;
    end;
    }

{
    asm
      mov     dx, 3DAH
@@1:  in      al, dx
      test    al, 8
      jz      @@1
    end;
}

    move_lense;

    for n := 1 to NN do
      redraw(lx[n]-rx,ly[n]-ry,lx[n]+rx,ly[n]+ry);

    if port[$60] <> p60 then break;

    asm
      mov     ax, 0003h
      int     33h
      mov     mb1t, bx
      mov     mb2t, cx
      mov     mb3t, dx
    end;
    if mb1t<>mb1 then
    if mb2t<>mb2 then
    if mb3t<>mb3 then
      break;

  until false;

  asm
    mov     ax, 3
    int     10h
  end;

  move(video, mem[segb800:0], sizeof(video));
  gotoxy(wx, wy);

  while keypressed do readkey;

end.
