
#include <windows.h>
#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#pragma hdrstop

//#define DWORD ULONG

char* access_str[4] =
{
  "FILE_ANY_ACCESS",        // 0
  "FILE_READ_ACCESS",       // 1
  "FILE_WRITE_ACCESS",      // 2
  "3"                       // 3
};

char* method_str[4] =
{
  "METHOD_BUFFERED",        // 0
  "METHOD_IN_DIRECT",       // 1
  "METHOD_OUT_DIRECT",      // 2
  "METHOD_NEITHER"          // 3
};

struct device_entry
{
  DWORD device_code;
  char* device_str;
};

struct ctl_entry
{
  DWORD ctl_code;
  char* ctl_str;
};

struct device_entry device_array[] =
{
  { FILE_DEVICE_BEEP                   , "FILE_DEVICE_BEEP"                   },
  { FILE_DEVICE_CD_ROM                 , "FILE_DEVICE_CD_ROM"                 },
  { FILE_DEVICE_CD_ROM_FILE_SYSTEM     , "FILE_DEVICE_CD_ROM_FILE_SYSTEM"     },
  { FILE_DEVICE_CONTROLLER             , "FILE_DEVICE_CONTROLLER"             },
  { FILE_DEVICE_DATALINK               , "FILE_DEVICE_DATALINK"               },
  { FILE_DEVICE_DFS                    , "FILE_DEVICE_DFS"                    },
  { FILE_DEVICE_DISK                   , "FILE_DEVICE_DISK"                   },
  { FILE_DEVICE_DISK_FILE_SYSTEM       , "FILE_DEVICE_DISK_FILE_SYSTEM"       },
  { FILE_DEVICE_FILE_SYSTEM            , "FILE_DEVICE_FILE_SYSTEM"            },
  { FILE_DEVICE_INPORT_PORT            , "FILE_DEVICE_INPORT_PORT"            },
  { FILE_DEVICE_KEYBOARD               , "FILE_DEVICE_KEYBOARD"               },
  { FILE_DEVICE_MAILSLOT               , "FILE_DEVICE_MAILSLOT"               },
  { FILE_DEVICE_MIDI_IN                , "FILE_DEVICE_MIDI_IN"                },
  { FILE_DEVICE_MIDI_OUT               , "FILE_DEVICE_MIDI_OUT"               },
  { FILE_DEVICE_MOUSE                  , "FILE_DEVICE_MOUSE"                  },
  { FILE_DEVICE_MULTI_UNC_PROVIDER     , "FILE_DEVICE_MULTI_UNC_PROVIDER"     },
  { FILE_DEVICE_NAMED_PIPE             , "FILE_DEVICE_NAMED_PIPE"             },
  { FILE_DEVICE_NETWORK                , "FILE_DEVICE_NETWORK"                },
  { FILE_DEVICE_NETWORK_BROWSER        , "FILE_DEVICE_NETWORK_BROWSER"        },
  { FILE_DEVICE_NETWORK_FILE_SYSTEM    , "FILE_DEVICE_NETWORK_FILE_SYSTEM"    },
  { FILE_DEVICE_NULL                   , "FILE_DEVICE_NULL"                   },
  { FILE_DEVICE_PARALLEL_PORT          , "FILE_DEVICE_PARALLEL_PORT"          },
  { FILE_DEVICE_PHYSICAL_NETCARD       , "FILE_DEVICE_PHYSICAL_NETCARD"       },
  { FILE_DEVICE_PRINTER                , "FILE_DEVICE_PRINTER"                },
  { FILE_DEVICE_SCANNER                , "FILE_DEVICE_SCANNER"                },
  { FILE_DEVICE_SERIAL_MOUSE_PORT      , "FILE_DEVICE_SERIAL_MOUSE_PORT"      },
  { FILE_DEVICE_SERIAL_PORT            , "FILE_DEVICE_SERIAL_PORT"            },
  { FILE_DEVICE_SCREEN                 , "FILE_DEVICE_SCREEN"                 },
  { FILE_DEVICE_SOUND                  , "FILE_DEVICE_SOUND"                  },
  { FILE_DEVICE_STREAMS                , "FILE_DEVICE_STREAMS"                },
  { FILE_DEVICE_TAPE                   , "FILE_DEVICE_TAPE"                   },
  { FILE_DEVICE_TAPE_FILE_SYSTEM       , "FILE_DEVICE_TAPE_FILE_SYSTEM"       },
  { FILE_DEVICE_TRANSPORT              , "FILE_DEVICE_TRANSPORT"              },
  { FILE_DEVICE_UNKNOWN                , "FILE_DEVICE_UNKNOWN"                },
  { FILE_DEVICE_VIDEO                  , "FILE_DEVICE_VIDEO"                  },
  { FILE_DEVICE_VIRTUAL_DISK           , "FILE_DEVICE_VIRTUAL_DISK"           },
  { FILE_DEVICE_WAVE_IN                , "FILE_DEVICE_WAVE_IN"                },
  { FILE_DEVICE_WAVE_OUT               , "FILE_DEVICE_WAVE_OUT"               },
  { FILE_DEVICE_8042_PORT              , "FILE_DEVICE_8042_PORT"              },
  { FILE_DEVICE_NETWORK_REDIRECTOR     , "FILE_DEVICE_NETWORK_REDIRECTOR"     },
  { FILE_DEVICE_BATTERY                , "FILE_DEVICE_BATTERY"                },
  { FILE_DEVICE_BUS_EXTENDER           , "FILE_DEVICE_BUS_EXTENDER"           },
  { FILE_DEVICE_MODEM                  , "FILE_DEVICE_MODEM"                  },
  { FILE_DEVICE_VDM                    , "FILE_DEVICE_VDM"                    },
  { FILE_DEVICE_MASS_STORAGE           , "FILE_DEVICE_MASS_STORAGE"           },
  { FILE_DEVICE_SMB                    , "FILE_DEVICE_SMB"                    },
  { FILE_DEVICE_KS                     , "FILE_DEVICE_KS"                     },
  { FILE_DEVICE_CHANGER                , "FILE_DEVICE_CHANGER"                },
  { FILE_DEVICE_SMARTCARD              , "FILE_DEVICE_SMARTCARD"              },
  { FILE_DEVICE_ACPI                   , "FILE_DEVICE_ACPI"                   },
  { FILE_DEVICE_DVD                    , "FILE_DEVICE_DVD"                    },
  { FILE_DEVICE_FULLSCREEN_VIDEO       , "FILE_DEVICE_FULLSCREEN_VIDEO"       },
  { FILE_DEVICE_DFS_FILE_SYSTEM        , "FILE_DEVICE_DFS_FILE_SYSTEM"        },
  { FILE_DEVICE_DFS_VOLUME             , "FILE_DEVICE_DFS_VOLUME"             },
  { FILE_DEVICE_SERENUM                , "FILE_DEVICE_SERENUM"                },
  { FILE_DEVICE_TERMSRV                , "FILE_DEVICE_TERMSRV"                },
  { FILE_DEVICE_KSEC                   , "FILE_DEVICE_KSEC"                   },

  {0,NULL}
};

struct ctl_entry ctl_array[] =
{
  { IOCTL_STORAGE_CHECK_VERIFY               , "IOCTL_STORAGE_CHECK_VERIFY"                      },
  { IOCTL_STORAGE_CHECK_VERIFY2              , "IOCTL_STORAGE_CHECK_VERIFY2"                     },
  { IOCTL_STORAGE_MEDIA_REMOVAL              , "IOCTL_STORAGE_MEDIA_REMOVAL"                     },
  { IOCTL_STORAGE_EJECT_MEDIA                , "IOCTL_STORAGE_EJECT_MEDIA"                       },
  { IOCTL_STORAGE_LOAD_MEDIA                 , "IOCTL_STORAGE_LOAD_MEDIA"                        },
  { IOCTL_STORAGE_LOAD_MEDIA2                , "IOCTL_STORAGE_LOAD_MEDIA2"                       },
  { IOCTL_STORAGE_RESERVE                    , "IOCTL_STORAGE_RESERVE"                           },
  { IOCTL_STORAGE_RELEASE                    , "IOCTL_STORAGE_RELEASE"                           },
  { IOCTL_STORAGE_FIND_NEW_DEVICES           , "IOCTL_STORAGE_FIND_NEW_DEVICES"                  },
  { IOCTL_STORAGE_EJECTION_CONTROL           , "IOCTL_STORAGE_EJECTION_CONTROL"                  },
  { IOCTL_STORAGE_MCN_CONTROL                , "IOCTL_STORAGE_MCN_CONTROL"                       },
  { IOCTL_STORAGE_GET_MEDIA_TYPES            , "IOCTL_STORAGE_GET_MEDIA_TYPES"                   },
  { IOCTL_STORAGE_GET_MEDIA_TYPES_EX         , "IOCTL_STORAGE_GET_MEDIA_TYPES_EX"                },
  { IOCTL_STORAGE_RESET_BUS                  , "IOCTL_STORAGE_RESET_BUS"                         },
  { IOCTL_STORAGE_RESET_DEVICE               , "IOCTL_STORAGE_RESET_DEVICE"                      },
  { IOCTL_STORAGE_GET_DEVICE_NUMBER          , "IOCTL_STORAGE_GET_DEVICE_NUMBER"                 },
  { IOCTL_STORAGE_PREDICT_FAILURE            , "IOCTL_STORAGE_PREDICT_FAILURE"                   },
  { OBSOLETE_IOCTL_STORAGE_RESET_BUS         , "OBSOLETE_IOCTL_STORAGE_RESET_BUS"                },
  { OBSOLETE_IOCTL_STORAGE_RESET_DEVICE      , "OBSOLETE_IOCTL_STORAGE_RESET_DEVICE"             },
  { IOCTL_DISK_GET_DRIVE_GEOMETRY            , "IOCTL_DISK_GET_DRIVE_GEOMETRY"                   },
  { IOCTL_DISK_GET_PARTITION_INFO            , "IOCTL_DISK_GET_PARTITION_INFO"                   },
  { IOCTL_DISK_SET_PARTITION_INFO            , "IOCTL_DISK_SET_PARTITION_INFO"                   },
  { IOCTL_DISK_GET_DRIVE_LAYOUT              , "IOCTL_DISK_GET_DRIVE_LAYOUT"                     },
  { IOCTL_DISK_SET_DRIVE_LAYOUT              , "IOCTL_DISK_SET_DRIVE_LAYOUT"                     },
  { IOCTL_DISK_VERIFY                        , "IOCTL_DISK_VERIFY"                               },
  { IOCTL_DISK_FORMAT_TRACKS                 , "IOCTL_DISK_FORMAT_TRACKS"                        },
  { IOCTL_DISK_REASSIGN_BLOCKS               , "IOCTL_DISK_REASSIGN_BLOCKS"                      },
  { IOCTL_DISK_PERFORMANCE                   , "IOCTL_DISK_PERFORMANCE"                          },
  { IOCTL_DISK_IS_WRITABLE                   , "IOCTL_DISK_IS_WRITABLE"                          },
  { IOCTL_DISK_LOGGING                       , "IOCTL_DISK_LOGGING"                              },
  { IOCTL_DISK_FORMAT_TRACKS_EX              , "IOCTL_DISK_FORMAT_TRACKS_EX"                     },
  { IOCTL_DISK_HISTOGRAM_STRUCTURE           , "IOCTL_DISK_HISTOGRAM_STRUCTURE"                  },
  { IOCTL_DISK_HISTOGRAM_DATA                , "IOCTL_DISK_HISTOGRAM_DATA"                       },
  { IOCTL_DISK_HISTOGRAM_RESET               , "IOCTL_DISK_HISTOGRAM_RESET"                      },
  { IOCTL_DISK_REQUEST_STRUCTURE             , "IOCTL_DISK_REQUEST_STRUCTURE"                    },
  { IOCTL_DISK_REQUEST_DATA                  , "IOCTL_DISK_REQUEST_DATA"                         },
  { IOCTL_DISK_CONTROLLER_NUMBER             , "IOCTL_DISK_CONTROLLER_NUMBER"                    },
  { SMART_GET_VERSION                        , "SMART_GET_VERSION"                               },
  { SMART_SEND_DRIVE_COMMAND                 , "SMART_SEND_DRIVE_COMMAND"                        },
  { SMART_RCV_DRIVE_DATA                     , "SMART_RCV_DRIVE_DATA"                            },
  { IOCTL_DISK_UPDATE_DRIVE_SIZE             , "IOCTL_DISK_UPDATE_DRIVE_SIZE"                    },
  { IOCTL_DISK_GROW_PARTITION                , "IOCTL_DISK_GROW_PARTITION"                       },
  { IOCTL_DISK_GET_CACHE_INFORMATION         , "IOCTL_DISK_GET_CACHE_INFORMATION"                },
  { IOCTL_DISK_SET_CACHE_INFORMATION         , "IOCTL_DISK_SET_CACHE_INFORMATION"                },
  { IOCTL_DISK_DELETE_DRIVE_LAYOUT           , "IOCTL_DISK_DELETE_DRIVE_LAYOUT"                  },
  { IOCTL_DISK_FORMAT_DRIVE                  , "IOCTL_DISK_FORMAT_DRIVE"                         },
  { IOCTL_DISK_SENSE_DEVICE                  , "IOCTL_DISK_SENSE_DEVICE"                         },
  { IOCTL_DISK_CHECK_VERIFY                  , "IOCTL_DISK_CHECK_VERIFY"                         },
  { IOCTL_DISK_MEDIA_REMOVAL                 , "IOCTL_DISK_MEDIA_REMOVAL"                        },
  { IOCTL_DISK_EJECT_MEDIA                   , "IOCTL_DISK_EJECT_MEDIA"                          },
  { IOCTL_DISK_LOAD_MEDIA                    , "IOCTL_DISK_LOAD_MEDIA"                           },
  { IOCTL_DISK_RESERVE                       , "IOCTL_DISK_RESERVE"                              },
  { IOCTL_DISK_RELEASE                       , "IOCTL_DISK_RELEASE"                              },
  { IOCTL_DISK_FIND_NEW_DEVICES              , "IOCTL_DISK_FIND_NEW_DEVICES"                     },
  { IOCTL_DISK_GET_MEDIA_TYPES               , "IOCTL_DISK_GET_MEDIA_TYPES"                      },
  { IOCTL_CHANGER_GET_PARAMETERS             , "IOCTL_CHANGER_GET_PARAMETERS"                    },
  { IOCTL_CHANGER_GET_STATUS                 , "IOCTL_CHANGER_GET_STATUS"                        },
  { IOCTL_CHANGER_GET_PRODUCT_DATA           , "IOCTL_CHANGER_GET_PRODUCT_DATA"                  },
  { IOCTL_CHANGER_SET_ACCESS                 , "IOCTL_CHANGER_SET_ACCESS"                        },
  { IOCTL_CHANGER_GET_ELEMENT_STATUS         , "IOCTL_CHANGER_GET_ELEMENT_STATUS"                },
  { IOCTL_CHANGER_INITIALIZE_ELEMENT_STATUS  , "IOCTL_CHANGER_INITIALIZE_ELEMENT_STATUS"         },
  { IOCTL_CHANGER_SET_POSITION               , "IOCTL_CHANGER_SET_POSITION"                      },
  { IOCTL_CHANGER_EXCHANGE_MEDIUM            , "IOCTL_CHANGER_EXCHANGE_MEDIUM"                   },
  { IOCTL_CHANGER_MOVE_MEDIUM                , "IOCTL_CHANGER_MOVE_MEDIUM"                       },
  { IOCTL_CHANGER_REINITIALIZE_TRANSPORT     , "IOCTL_CHANGER_REINITIALIZE_TRANSPORT"            },
  { IOCTL_CHANGER_QUERY_VOLUME_TAGS          , "IOCTL_CHANGER_QUERY_VOLUME_TAGS"                 },
  { IOCTL_SERIAL_LSRMST_INSERT               , "IOCTL_SERIAL_LSRMST_INSERT"                      },
  { IOCTL_SERENUM_EXPOSE_HARDWARE            , "IOCTL_SERENUM_EXPOSE_HARDWARE"                   },
  { IOCTL_SERENUM_REMOVE_HARDWARE            , "IOCTL_SERENUM_REMOVE_HARDWARE"                   },
  { IOCTL_SERENUM_PORT_DESC                  , "IOCTL_SERENUM_PORT_DESC"                         },
  { IOCTL_SERENUM_GET_PORT_NAME              , "IOCTL_SERENUM_GET_PORT_NAME"                     },
  { FSCTL_REQUEST_OPLOCK_LEVEL_1             , "FSCTL_REQUEST_OPLOCK_LEVEL_1"                    },
  { FSCTL_REQUEST_OPLOCK_LEVEL_2             , "FSCTL_REQUEST_OPLOCK_LEVEL_2"                    },
  { FSCTL_REQUEST_BATCH_OPLOCK               , "FSCTL_REQUEST_BATCH_OPLOCK"                      },
  { FSCTL_OPLOCK_BREAK_ACKNOWLEDGE           , "FSCTL_OPLOCK_BREAK_ACKNOWLEDGE"                  },
  { FSCTL_OPBATCH_ACK_CLOSE_PENDING          , "FSCTL_OPBATCH_ACK_CLOSE_PENDING"                 },
  { FSCTL_OPLOCK_BREAK_NOTIFY                , "FSCTL_OPLOCK_BREAK_NOTIFY"                       },
  { FSCTL_LOCK_VOLUME                        , "FSCTL_LOCK_VOLUME"                               },
  { FSCTL_UNLOCK_VOLUME                      , "FSCTL_UNLOCK_VOLUME"                             },
  { FSCTL_DISMOUNT_VOLUME                    , "FSCTL_DISMOUNT_VOLUME"                           },
  { FSCTL_IS_VOLUME_MOUNTED                  , "FSCTL_IS_VOLUME_MOUNTED"                         },
  { FSCTL_IS_PATHNAME_VALID                  , "FSCTL_IS_PATHNAME_VALID"                         },
  { FSCTL_MARK_VOLUME_DIRTY                  , "FSCTL_MARK_VOLUME_DIRTY"                         },
  { FSCTL_QUERY_RETRIEVAL_POINTERS           , "FSCTL_QUERY_RETRIEVAL_POINTERS"                  },
  { FSCTL_GET_COMPRESSION                    , "FSCTL_GET_COMPRESSION"                           },
  { FSCTL_SET_COMPRESSION                    , "FSCTL_SET_COMPRESSION"                           },
  { FSCTL_MARK_AS_SYSTEM_HIVE                , "FSCTL_MARK_AS_SYSTEM_HIVE"                       },
  { FSCTL_OPLOCK_BREAK_ACK_NO_2              , "FSCTL_OPLOCK_BREAK_ACK_NO_2"                     },
  { FSCTL_INVALIDATE_VOLUMES                 , "FSCTL_INVALIDATE_VOLUMES"                        },
  { FSCTL_QUERY_FAT_BPB                      , "FSCTL_QUERY_FAT_BPB"                             },
  { FSCTL_REQUEST_FILTER_OPLOCK              , "FSCTL_REQUEST_FILTER_OPLOCK"                     },
  { FSCTL_FILESYSTEM_GET_STATISTICS          , "FSCTL_FILESYSTEM_GET_STATISTICS"                 },
  { FSCTL_GET_NTFS_VOLUME_DATA               , "FSCTL_GET_NTFS_VOLUME_DATA"                      },
  { FSCTL_GET_NTFS_FILE_RECORD               , "FSCTL_GET_NTFS_FILE_RECORD"                      },
  { FSCTL_GET_VOLUME_BITMAP                  , "FSCTL_GET_VOLUME_BITMAP"                         },
  { FSCTL_GET_RETRIEVAL_POINTERS             , "FSCTL_GET_RETRIEVAL_POINTERS"                    },
  { FSCTL_MOVE_FILE                          , "FSCTL_MOVE_FILE"                                 },
  { FSCTL_IS_VOLUME_DIRTY                    , "FSCTL_IS_VOLUME_DIRTY"                           },
  { FSCTL_GET_HFS_INFORMATION                , "FSCTL_GET_HFS_INFORMATION"                       },
  { FSCTL_ALLOW_EXTENDED_DASD_IO             , "FSCTL_ALLOW_EXTENDED_DASD_IO"                    },
  { FSCTL_READ_PROPERTY_DATA                 , "FSCTL_READ_PROPERTY_DATA"                        },
  { FSCTL_WRITE_PROPERTY_DATA                , "FSCTL_WRITE_PROPERTY_DATA"                       },
  { FSCTL_FIND_FILES_BY_SID                  , "FSCTL_FIND_FILES_BY_SID"                         },
  { FSCTL_DUMP_PROPERTY_DATA                 , "FSCTL_DUMP_PROPERTY_DATA"                        },
  { FSCTL_SET_OBJECT_ID                      , "FSCTL_SET_OBJECT_ID"                             },
  { FSCTL_GET_OBJECT_ID                      , "FSCTL_GET_OBJECT_ID"                             },
  { FSCTL_DELETE_OBJECT_ID                   , "FSCTL_DELETE_OBJECT_ID"                          },
  { FSCTL_SET_REPARSE_POINT                  , "FSCTL_SET_REPARSE_POINT"                         },
  { FSCTL_GET_REPARSE_POINT                  , "FSCTL_GET_REPARSE_POINT"                         },
  { FSCTL_DELETE_REPARSE_POINT               , "FSCTL_DELETE_REPARSE_POINT"                      },
  { FSCTL_ENUM_USN_DATA                      , "FSCTL_ENUM_USN_DATA"                             },
  { FSCTL_SECURITY_ID_CHECK                  , "FSCTL_SECURITY_ID_CHECK"                         },
  { FSCTL_READ_USN_JOURNAL                   , "FSCTL_READ_USN_JOURNAL"                          },
  { FSCTL_SET_OBJECT_ID_EXTENDED             , "FSCTL_SET_OBJECT_ID_EXTENDED"                    },
  { FSCTL_CREATE_OR_GET_OBJECT_ID            , "FSCTL_CREATE_OR_GET_OBJECT_ID"                   },
  { FSCTL_SET_SPARSE                         , "FSCTL_SET_SPARSE"                                },
  { FSCTL_SET_ZERO_DATA                      , "FSCTL_SET_ZERO_DATA"                             },
  { FSCTL_QUERY_ALLOCATED_RANGES             , "FSCTL_QUERY_ALLOCATED_RANGES"                    },
  { FSCTL_ENABLE_UPGRADE                     , "FSCTL_ENABLE_UPGRADE"                            },
  { FSCTL_SET_ENCRYPTION                     , "FSCTL_SET_ENCRYPTION"                            },
  { FSCTL_ENCRYPTION_FSCTL_IO                , "FSCTL_ENCRYPTION_FSCTL_IO"                       },
  { FSCTL_WRITE_RAW_ENCRYPTED                , "FSCTL_WRITE_RAW_ENCRYPTED"                       },
  { FSCTL_READ_RAW_ENCRYPTED                 , "FSCTL_READ_RAW_ENCRYPTED"                        },
  { FSCTL_CREATE_USN_JOURNAL                 , "FSCTL_CREATE_USN_JOURNAL"                        },
  { FSCTL_READ_FILE_USN_DATA                 , "FSCTL_READ_FILE_USN_DATA"                        },
  { FSCTL_WRITE_USN_CLOSE_RECORD             , "FSCTL_WRITE_USN_CLOSE_RECORD"                    },
  { FSCTL_EXTEND_VOLUME                      , "FSCTL_EXTEND_VOLUME"                             },
  { FSCTL_QUERY_USN_JOURNAL                  , "FSCTL_QUERY_USN_JOURNAL"                         },
  { FSCTL_DELETE_USN_JOURNAL                 , "FSCTL_DELETE_USN_JOURNAL"                        },
  { FSCTL_MARK_HANDLE                        , "FSCTL_MARK_HANDLE"                               },
  { FSCTL_SIS_COPYFILE                       , "FSCTL_SIS_COPYFILE"                              },
  { FSCTL_SIS_LINK_FILES                     , "FSCTL_SIS_LINK_FILES"                            },
  { FSCTL_HSM_MSG                            , "FSCTL_HSM_MSG"                                   },
  { FSCTL_NSS_CONTROL                        , "FSCTL_NSS_CONTROL"                               },
  { FSCTL_HSM_DATA                           , "FSCTL_HSM_DATA"                                  },
  { FSCTL_RECALL_FILE                        , "FSCTL_RECALL_FILE"                               },
  { FSCTL_NSS_RCONTROL                       , "FSCTL_NSS_RCONTROL"                              },
  { IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS     , "IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS"            },

/*
  { IOCTL_1394_CLASS                                     , "IOCTL_1394_CLASS"},
  { IOCTL_1394_TOGGLE_ENUM_TEST_ON                       , "IOCTL_1394_TOGGLE_ENUM_TEST_ON"},
  { IOCTL_1394_TOGGLE_ENUM_TEST_OFF                      , "IOCTL_1394_TOGGLE_ENUM_TEST_OFF"},
  { IOCTL_ACPI_ASYNC_EVAL_METHOD                         , "IOCTL_ACPI_ASYNC_EVAL_METHOD"},
  { IOCTL_ACPI_EVAL_METHOD                               , "IOCTL_ACPI_EVAL_METHOD"},
  { IOCTL_ACPI_ACQUIRE_GLOBAL_LOCK                       , "IOCTL_ACPI_ACQUIRE_GLOBAL_LOCK"},
  { IOCTL_ACPI_RELEASE_GLOBAL_LOCK                       , "IOCTL_ACPI_RELEASE_GLOBAL_LOCK"},
  { IOCTL_INTERNAL_DBC_SUBMIT_DRB                        , "IOCTL_INTERNAL_DBC_SUBMIT_DRB"},
  { IOCTL_GAMEENUM_EXPOSE_HARDWARE                       , "IOCTL_GAMEENUM_EXPOSE_HARDWARE"},
  { IOCTL_GAMEENUM_REMOVE_HARDWARE                       , "IOCTL_GAMEENUM_REMOVE_HARDWARE"},
  { IOCTL_GAMEENUM_PORT_DESC                             , "IOCTL_GAMEENUM_PORT_DESC"},
  { IOCTL_HID_GET_DRIVER_CONFIG                          , "IOCTL_HID_GET_DRIVER_CONFIG"},
  { IOCTL_HID_SET_DRIVER_CONFIG                          , "IOCTL_HID_SET_DRIVER_CONFIG"},
  { IOCTL_HID_GET_POLL_FREQUENCY_MSEC                    , "IOCTL_HID_GET_POLL_FREQUENCY_MSEC"},
  { IOCTL_HID_SET_POLL_FREQUENCY_MSEC                    , "IOCTL_HID_SET_POLL_FREQUENCY_MSEC"},
  { IOCTL_GET_NUM_DEVICE_INPUT_BUFFERS                   , "IOCTL_GET_NUM_DEVICE_INPUT_BUFFERS"},
  { IOCTL_SET_NUM_DEVICE_INPUT_BUFFERS                   , "IOCTL_SET_NUM_DEVICE_INPUT_BUFFERS"},
  { IOCTL_HID_GET_COLLECTION_INFORMATION                 , "IOCTL_HID_GET_COLLECTION_INFORMATION"},
  { IOCTL_HID_GET_COLLECTION_DESCRIPTOR                  , "IOCTL_HID_GET_COLLECTION_DESCRIPTOR"},
  { IOCTL_HID_FLUSH_QUEUE                                , "IOCTL_HID_FLUSH_QUEUE"},
  { IOCTL_HID_SET_FEATURE                                , "IOCTL_HID_SET_FEATURE"},
  { IOCTL_HID_GET_FEATURE                                , "IOCTL_HID_GET_FEATURE"},
  { IOCTL_GET_PHYSICAL_DESCRIPTOR                        , "IOCTL_GET_PHYSICAL_DESCRIPTOR"},
  { IOCTL_HID_GET_HARDWARE_ID                            , "IOCTL_HID_GET_HARDWARE_ID"},
  { IOCTL_HID_GET_MANUFACTURER_STRING                    , "IOCTL_HID_GET_MANUFACTURER_STRING"},
  { IOCTL_HID_GET_PRODUCT_STRING                         , "IOCTL_HID_GET_PRODUCT_STRING"},
  { IOCTL_HID_GET_SERIALNUMBER_STRING                    , "IOCTL_HID_GET_SERIALNUMBER_STRING"},
  { IOCTL_HID_GET_INDEXED_STRING                         , "IOCTL_HID_GET_INDEXED_STRING"},
  { IOCTL_IP_SET_FIREWALL_HOOK                           , "IOCTL_IP_SET_FIREWALL_HOOK"},
  { IOCTL_KS_PROPERTY                                    , "IOCTL_KS_PROPERTY"},
  { IOCTL_KS_ENABLE_EVENT                                , "IOCTL_KS_ENABLE_EVENT"},
  { IOCTL_KS_DISABLE_EVENT                               , "IOCTL_KS_DISABLE_EVENT"},
  { IOCTL_KS_METHOD                                      , "IOCTL_KS_METHOD"},
  { IOCTL_KS_WRITE_STREAM                                , "IOCTL_KS_WRITE_STREAM"},
  { IOCTL_KS_READ_STREAM                                 , "IOCTL_KS_READ_STREAM"},
  { IOCTL_KS_RESET_STATE                                 , "IOCTL_KS_RESET_STATE"},
  { IOCTL_MOUNTDEV_QUERY_UNIQUE_ID                       , "IOCTL_MOUNTDEV_QUERY_UNIQUE_ID"},
  { IOCTL_MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY               , "IOCTL_MOUNTDEV_UNIQUE_ID_CHANGE_NOTIFY"},
  { IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME             , "IOCTL_MOUNTDEV_QUERY_SUGGESTED_LINK_NAME"},
  { IOCTL_MOUNTDEV_LINK_CREATED                          , "IOCTL_MOUNTDEV_LINK_CREATED"},
  { IOCTL_MOUNTDEV_LINK_DELETED                          , "IOCTL_MOUNTDEV_LINK_DELETED"},
  { IOCTL_MOUNTMGR_CREATE_POINT                          , "IOCTL_MOUNTMGR_CREATE_POINT"},
  { IOCTL_MOUNTMGR_DELETE_POINTS                         , "IOCTL_MOUNTMGR_DELETE_POINTS"},
  { IOCTL_MOUNTMGR_QUERY_POINTS                          , "IOCTL_MOUNTMGR_QUERY_POINTS"},
  { IOCTL_MOUNTMGR_DELETE_POINTS_DBONLY                  , "IOCTL_MOUNTMGR_DELETE_POINTS_DBONLY"},
  { IOCTL_MOUNTMGR_NEXT_DRIVE_LETTER                     , "IOCTL_MOUNTMGR_NEXT_DRIVE_LETTER"},
  { IOCTL_MOUNTMGR_AUTO_DL_ASSIGNMENTS                   , "IOCTL_MOUNTMGR_AUTO_DL_ASSIGNMENTS"},
  { IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_CREATED            , "IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_CREATED"},
  { IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_DELETED            , "IOCTL_MOUNTMGR_VOLUME_MOUNT_POINT_DELETED"},
  { IOCTL_MOUNTMGR_CHANGE_NOTIFY                         , "IOCTL_MOUNTMGR_CHANGE_NOTIFY"},
  { IOCTL_MOUNTMGR_KEEP_LINKS_WHEN_OFFLINE               , "IOCTL_MOUNTMGR_KEEP_LINKS_WHEN_OFFLINE"},
  { IOCTL_MOUNTMGR_CHECK_UNPROCESSED_VOLUMES             , "IOCTL_MOUNTMGR_CHECK_UNPROCESSED_VOLUMES"},
  { IOCTL_MOUNTMGR_VOLUME_ARRIVAL_NOTIFICATION           , "IOCTL_MOUNTMGR_VOLUME_ARRIVAL_NOTIFICATION"},
  { IOCTL_MOUNTDEV_QUERY_DEVICE_NAME                     , "IOCTL_MOUNTDEV_QUERY_DEVICE_NAME"},
  { IOCTL_INTERNAL_I8042_HOOK_KEYBOARD                   , "IOCTL_INTERNAL_I8042_HOOK_KEYBOARD"},
  { IOCTL_INTERNAL_I8042_HOOK_MOUSE                      , "IOCTL_INTERNAL_I8042_HOOK_MOUSE"},
  { IOCTL_INTERNAL_I8042_KEYBOARD_WRITE_BUFFER           , "IOCTL_INTERNAL_I8042_KEYBOARD_WRITE_BUFFER"},
  { IOCTL_INTERNAL_I8042_MOUSE_WRITE_BUFFER              , "IOCTL_INTERNAL_I8042_MOUSE_WRITE_BUFFER"},
  { IOCTL_INTERNAL_I8042_KEYBOARD_START_INFORMATION      , "IOCTL_INTERNAL_I8042_KEYBOARD_START_INFORMATION"},
  { IOCTL_INTERNAL_I8042_MOUSE_START_INFORMATION         , "IOCTL_INTERNAL_I8042_MOUSE_START_INFORMATION"},
  { IOCTL_BEEP_SET                                       , "IOCTL_BEEP_SET"},
  { IOCTL_CDROM_UNLOAD_DRIVER                            , "IOCTL_CDROM_UNLOAD_DRIVER"},
  { IOCTL_CDROM_READ_TOC                                 , "IOCTL_CDROM_READ_TOC"},
  { IOCTL_CDROM_GET_CONTROL                              , "IOCTL_CDROM_GET_CONTROL"},
  { IOCTL_CDROM_PLAY_AUDIO_MSF                           , "IOCTL_CDROM_PLAY_AUDIO_MSF"},
  { IOCTL_CDROM_SEEK_AUDIO_MSF                           , "IOCTL_CDROM_SEEK_AUDIO_MSF"},
  { IOCTL_CDROM_STOP_AUDIO                               , "IOCTL_CDROM_STOP_AUDIO"},
  { IOCTL_CDROM_PAUSE_AUDIO                              , "IOCTL_CDROM_PAUSE_AUDIO"},
  { IOCTL_CDROM_RESUME_AUDIO                             , "IOCTL_CDROM_RESUME_AUDIO"},
  { IOCTL_CDROM_GET_VOLUME                               , "IOCTL_CDROM_GET_VOLUME"},
  { IOCTL_CDROM_SET_VOLUME                               , "IOCTL_CDROM_SET_VOLUME"},
  { IOCTL_CDROM_READ_Q_CHANNEL                           , "IOCTL_CDROM_READ_Q_CHANNEL"},
  { IOCTL_CDROM_GET_LAST_SESSION                         , "IOCTL_CDROM_GET_LAST_SESSION"},
  { IOCTL_CDROM_RAW_READ                                 , "IOCTL_CDROM_RAW_READ"},
  { IOCTL_CDROM_DISK_TYPE                                , "IOCTL_CDROM_DISK_TYPE"},
  { IOCTL_CDROM_GET_DRIVE_GEOMETRY                       , "IOCTL_CDROM_GET_DRIVE_GEOMETRY"},
  { IOCTL_CDROM_CHECK_VERIFY                             , "IOCTL_CDROM_CHECK_VERIFY"},
  { IOCTL_CDROM_MEDIA_REMOVAL                            , "IOCTL_CDROM_MEDIA_REMOVAL"},
  { IOCTL_CDROM_EJECT_MEDIA                              , "IOCTL_CDROM_EJECT_MEDIA"},
  { IOCTL_CDROM_LOAD_MEDIA                               , "IOCTL_CDROM_LOAD_MEDIA"},
  { IOCTL_CDROM_RESERVE                                  , "IOCTL_CDROM_RESERVE"},
  { IOCTL_CDROM_RELEASE                                  , "IOCTL_CDROM_RELEASE"},
  { IOCTL_CDROM_FIND_NEW_DEVICES                         , "IOCTL_CDROM_FIND_NEW_DEVICES"},
  { IOCTL_CDROM_SIMBAD                                   , "IOCTL_CDROM_SIMBAD"},
  { IOCTL_DISK_GET_DRIVE_GEOMETRY                        , "IOCTL_DISK_GET_DRIVE_GEOMETRY"},
  { IOCTL_DISK_GET_PARTITION_INFO                        , "IOCTL_DISK_GET_PARTITION_INFO"},
  { IOCTL_DISK_SET_PARTITION_INFO                        , "IOCTL_DISK_SET_PARTITION_INFO"},
  { IOCTL_DISK_GET_DRIVE_LAYOUT                          , "IOCTL_DISK_GET_DRIVE_LAYOUT"},
  { IOCTL_DISK_SET_DRIVE_LAYOUT                          , "IOCTL_DISK_SET_DRIVE_LAYOUT"},
  { IOCTL_DISK_VERIFY                                    , "IOCTL_DISK_VERIFY"},
  { IOCTL_DISK_FORMAT_TRACKS                             , "IOCTL_DISK_FORMAT_TRACKS"},
  { IOCTL_DISK_REASSIGN_BLOCKS                           , "IOCTL_DISK_REASSIGN_BLOCKS"},
  { IOCTL_DISK_PERFORMANCE                               , "IOCTL_DISK_PERFORMANCE"},
  { IOCTL_DISK_IS_WRITABLE                               , "IOCTL_DISK_IS_WRITABLE"},
  { IOCTL_DISK_LOGGING                                   , "IOCTL_DISK_LOGGING"},
  { IOCTL_DISK_FORMAT_TRACKS_EX                          , "IOCTL_DISK_FORMAT_TRACKS_EX"},
  { IOCTL_DISK_HISTOGRAM_STRUCTURE                       , "IOCTL_DISK_HISTOGRAM_STRUCTURE"},
  { IOCTL_DISK_HISTOGRAM_DATA                            , "IOCTL_DISK_HISTOGRAM_DATA"},
  { IOCTL_DISK_HISTOGRAM_RESET                           , "IOCTL_DISK_HISTOGRAM_RESET"},
  { IOCTL_DISK_REQUEST_STRUCTURE                         , "IOCTL_DISK_REQUEST_STRUCTURE"},
  { IOCTL_DISK_REQUEST_DATA                              , "IOCTL_DISK_REQUEST_DATA"},
  { IOCTL_DISK_CONTROLLER_NUMBER                         , "IOCTL_DISK_CONTROLLER_NUMBER"},
  { SMART_GET_VERSION                                    , "SMART_GET_VERSION"},
  { SMART_SEND_DRIVE_COMMAND                             , "SMART_SEND_DRIVE_COMMAND"},
  { SMART_RCV_DRIVE_DATA                                 , "SMART_RCV_DRIVE_DATA"},
  { IOCTL_DISK_UPDATE_DRIVE_SIZE                         , "IOCTL_DISK_UPDATE_DRIVE_SIZE"},
  { IOCTL_DISK_GROW_PARTITION                            , "IOCTL_DISK_GROW_PARTITION"},
  { IOCTL_DISK_GET_CACHE_INFORMATION                     , "IOCTL_DISK_GET_CACHE_INFORMATION"},
  { IOCTL_DISK_SET_CACHE_INFORMATION                     , "IOCTL_DISK_SET_CACHE_INFORMATION"},
  { IOCTL_DISK_DELETE_DRIVE_LAYOUT                       , "IOCTL_DISK_DELETE_DRIVE_LAYOUT"},
  { IOCTL_DISK_FORMAT_DRIVE                              , "IOCTL_DISK_FORMAT_DRIVE"},
  { IOCTL_DISK_SENSE_DEVICE                              , "IOCTL_DISK_SENSE_DEVICE"},
  { IOCTL_DISK_INTERNAL_SET_VERIFY                       , "IOCTL_DISK_INTERNAL_SET_VERIFY"},
  { IOCTL_DISK_INTERNAL_CLEAR_VERIFY                     , "IOCTL_DISK_INTERNAL_CLEAR_VERIFY"},
  { IOCTL_DISK_INTERNAL_SET_NOTIFY                       , "IOCTL_DISK_INTERNAL_SET_NOTIFY"},
  { IOCTL_DISK_CHECK_VERIFY                              , "IOCTL_DISK_CHECK_VERIFY"},
  { IOCTL_DISK_MEDIA_REMOVAL                             , "IOCTL_DISK_MEDIA_REMOVAL"},
  { IOCTL_DISK_EJECT_MEDIA                               , "IOCTL_DISK_EJECT_MEDIA"},
  { IOCTL_DISK_LOAD_MEDIA                                , "IOCTL_DISK_LOAD_MEDIA"},
  { IOCTL_DISK_RESERVE                                   , "IOCTL_DISK_RESERVE"},
  { IOCTL_DISK_RELEASE                                   , "IOCTL_DISK_RELEASE"},
  { IOCTL_DISK_FIND_NEW_DEVICES                          , "IOCTL_DISK_FIND_NEW_DEVICES"},
  { IOCTL_DISK_GET_MEDIA_TYPES                           , "IOCTL_DISK_GET_MEDIA_TYPES"},
  { IOCTL_DISK_SIMBAD                                    , "IOCTL_DISK_SIMBAD"},
  { FT_INITIALIZE_SET                                    , "FT_INITIALIZE_SET"},
  { FT_REGENERATE                                        , "FT_REGENERATE"},
  { FT_CONFIGURE                                         , "FT_CONFIGURE"},
  { FT_VERIFY                                            , "FT_VERIFY"},
  { FT_SECONDARY_READ                                    , "FT_SECONDARY_READ"},
  { FT_PRIMARY_READ                                      , "FT_PRIMARY_READ"},
  { FT_BALANCED_READ_MODE                                , "FT_BALANCED_READ_MODE"},
  { FT_SYNC_REDUNDANT_COPY                               , "FT_SYNC_REDUNDANT_COPY"},
  { FT_SEQUENTIAL_WRITE_MODE                             , "FT_SEQUENTIAL_WRITE_MODE"},
  { FT_PARALLEL_WRITE_MODE                               , "FT_PARALLEL_WRITE_MODE"},
  { FT_QUERY_SET_STATE                                   , "FT_QUERY_SET_STATE"},
  { FT_CLUSTER_SET_MEMBER_STATE                          , "FT_CLUSTER_SET_MEMBER_STATE"},
  { FT_CLUSTER_GET_MEMBER_STATE                          , "FT_CLUSTER_GET_MEMBER_STATE"},
  { FT_CREATE_LOGICAL_DISK                               , "FT_CREATE_LOGICAL_DISK"},
  { FT_BREAK_LOGICAL_DISK                                , "FT_BREAK_LOGICAL_DISK"},
  { FT_ENUMERATE_LOGICAL_DISKS                           , "FT_ENUMERATE_LOGICAL_DISKS"},
  { FT_QUERY_LOGICAL_DISK_INFORMATION                    , "FT_QUERY_LOGICAL_DISK_INFORMATION"},
  { FT_ORPHAN_LOGICAL_DISK_MEMBER                        , "FT_ORPHAN_LOGICAL_DISK_MEMBER"},
  { FT_REPLACE_LOGICAL_DISK_MEMBER                       , "FT_REPLACE_LOGICAL_DISK_MEMBER"},
  { FT_QUERY_NT_DEVICE_NAME_FOR_LOGICAL_DISK             , "FT_QUERY_NT_DEVICE_NAME_FOR_LOGICAL_DISK"},
  { FT_INITIALIZE_LOGICAL_DISK                           , "FT_INITIALIZE_LOGICAL_DISK"},
  { FT_QUERY_DRIVE_LETTER_FOR_LOGICAL_DISK               , "FT_QUERY_DRIVE_LETTER_FOR_LOGICAL_DISK"},
  { FT_CHECK_IO                                          , "FT_CHECK_IO"},
  { FT_SET_DRIVE_LETTER_FOR_LOGICAL_DISK                 , "FT_SET_DRIVE_LETTER_FOR_LOGICAL_DISK"},
  { FT_QUERY_NT_DEVICE_NAME_FOR_PARTITION                , "FT_QUERY_NT_DEVICE_NAME_FOR_PARTITION"},
  { FT_CHANGE_NOTIFY                                     , "FT_CHANGE_NOTIFY"},
  { FT_STOP_SYNC_OPERATIONS                              , "FT_STOP_SYNC_OPERATIONS"},
  { FT_QUERY_LOGICAL_DISK_ID                             , "FT_QUERY_LOGICAL_DISK_ID"},
  { FT_CREATE_PARTITION_LOGICAL_DISK                     , "FT_CREATE_PARTITION_LOGICAL_DISK"},
  { IOCTL_QUERY_DEVICE_POWER_STATE                       , "IOCTL_QUERY_DEVICE_POWER_STATE"},
  { IOCTL_SET_DEVICE_WAKE                                , "IOCTL_SET_DEVICE_WAKE"},
  { IOCTL_CANCEL_DEVICE_WAKE                             , "IOCTL_CANCEL_DEVICE_WAKE"},
  { IOCTL_KEYBOARD_QUERY_ATTRIBUTES                      , "IOCTL_KEYBOARD_QUERY_ATTRIBUTES"},
  { IOCTL_KEYBOARD_SET_TYPEMATIC                         , "IOCTL_KEYBOARD_SET_TYPEMATIC"},
  { IOCTL_KEYBOARD_SET_INDICATORS                        , "IOCTL_KEYBOARD_SET_INDICATORS"},
  { IOCTL_KEYBOARD_QUERY_TYPEMATIC                       , "IOCTL_KEYBOARD_QUERY_TYPEMATIC"},
  { IOCTL_KEYBOARD_QUERY_INDICATORS                      , "IOCTL_KEYBOARD_QUERY_INDICATORS"},
  { IOCTL_KEYBOARD_QUERY_INDICATOR_TRANSLATION           , "IOCTL_KEYBOARD_QUERY_INDICATOR_TRANSLATION"},
  { IOCTL_KEYBOARD_INSERT_DATA                           , "IOCTL_KEYBOARD_INSERT_DATA"},
  { IOCTL_KEYBOARD_QUERY_IME_STATUS                      , "IOCTL_KEYBOARD_QUERY_IME_STATUS"},
  { IOCTL_KEYBOARD_SET_IME_STATUS                        , "IOCTL_KEYBOARD_SET_IME_STATUS"},
  { IOCTL_MOUSE_QUERY_ATTRIBUTES                         , "IOCTL_MOUSE_QUERY_ATTRIBUTES"},
  { IOCTL_MOUSE_INSERT_DATA                              , "IOCTL_MOUSE_INSERT_DATA"},
  { IOCTL_NDIS_QUERY_GLOBAL_STATS                        , "IOCTL_NDIS_QUERY_GLOBAL_STATS"},
  { IOCTL_NDIS_QUERY_ALL_STATS                           , "IOCTL_NDIS_QUERY_ALL_STATS"},
  { IOCTL_NDIS_DO_PNP_OPERATION                          , "IOCTL_NDIS_DO_PNP_OPERATION"},
  { IOCTL_NDIS_QUERY_SELECTED_STATS                      , "IOCTL_NDIS_QUERY_SELECTED_STATS"},
  { IOCTL_NDIS_ENUMERATE_INTERFACES                      , "IOCTL_NDIS_ENUMERATE_INTERFACES"},
  { IOCTL_NDIS_ADD_TDI_DEVICE                            , "IOCTL_NDIS_ADD_TDI_DEVICE"},
  { IOCTL_NDIS_GET_DEVICE_BUNDLE                         , "IOCTL_NDIS_GET_DEVICE_BUNDLE"},
  { IOCTL_NDIS_GET_LOG_DATA                              , "IOCTL_NDIS_GET_LOG_DATA"},
  { IOCTL_PAR_QUERY_INFORMATION                          , "IOCTL_PAR_QUERY_INFORMATION"},
  { IOCTL_PAR_SET_INFORMATION                            , "IOCTL_PAR_SET_INFORMATION"},
  { IOCTL_PAR_QUERY_DEVICE_ID                            , "IOCTL_PAR_QUERY_DEVICE_ID"},
  { IOCTL_PAR_QUERY_DEVICE_ID_SIZE                       , "IOCTL_PAR_QUERY_DEVICE_ID_SIZE"},
  { IOCTL_IEEE1284_GET_MODE                              , "IOCTL_IEEE1284_GET_MODE"},
  { IOCTL_IEEE1284_NEGOTIATE                             , "IOCTL_IEEE1284_NEGOTIATE"},
  { IOCTL_PAR_SET_WRITE_ADDRESS                          , "IOCTL_PAR_SET_WRITE_ADDRESS"},
  { IOCTL_PAR_SET_READ_ADDRESS                           , "IOCTL_PAR_SET_READ_ADDRESS"},
  { IOCTL_PAR_GET_DEVICE_CAPS                            , "IOCTL_PAR_GET_DEVICE_CAPS"},
  { IOCTL_PAR_GET_DEFAULT_MODES                          , "IOCTL_PAR_GET_DEFAULT_MODES"},
  { IOCTL_PAR_PING                                       , "IOCTL_PAR_PING"},
  { IOCTL_PAR_QUERY_RAW_DEVICE_ID                        , "IOCTL_PAR_QUERY_RAW_DEVICE_ID"},
  { IOCTL_PAR_ECP_HOST_RECOVERY                          , "IOCTL_PAR_ECP_HOST_RECOVERY"},
  { IOCTL_PAR_GET_READ_ADDRESS                           , "IOCTL_PAR_GET_READ_ADDRESS"},
  { IOCTL_PAR_GET_WRITE_ADDRESS                          , "IOCTL_PAR_GET_WRITE_ADDRESS"},
  { IOCTL_PAR_TEST                                       , "IOCTL_PAR_TEST"},
  { IOCTL_PAR_IS_PORT_FREE                               , "IOCTL_PAR_IS_PORT_FREE"},
  { IOCTL_GET_TUPLE_DATA                                 , "IOCTL_GET_TUPLE_DATA"},
  { IOCTL_SOCKET_INFORMATION                             , "IOCTL_SOCKET_INFORMATION"},
  { IOCTL_SCSI_PASS_THROUGH                              , "IOCTL_SCSI_PASS_THROUGH"},
  { IOCTL_SCSI_MINIPORT                                  , "IOCTL_SCSI_MINIPORT"},
  { IOCTL_SCSI_GET_INQUIRY_DATA                          , "IOCTL_SCSI_GET_INQUIRY_DATA"},
  { IOCTL_SCSI_GET_CAPABILITIES                          , "IOCTL_SCSI_GET_CAPABILITIES"},
  { IOCTL_SCSI_PASS_THROUGH_DIRECT                       , "IOCTL_SCSI_PASS_THROUGH_DIRECT"},
  { IOCTL_SCSI_GET_ADDRESS                               , "IOCTL_SCSI_GET_ADDRESS"},
  { IOCTL_SCSI_RESCAN_BUS                                , "IOCTL_SCSI_RESCAN_BUS"},
  { IOCTL_SCSI_GET_DUMP_POINTERS                         , "IOCTL_SCSI_GET_DUMP_POINTERS"},
  { IOCTL_SCSI_FREE_DUMP_POINTERS                        , "IOCTL_SCSI_FREE_DUMP_POINTERS"},
  { IOCTL_IDE_PASS_THROUGH                               , "IOCTL_IDE_PASS_THROUGH"},
  { IOCTL_SERIAL_SET_BAUD_RATE                           , "IOCTL_SERIAL_SET_BAUD_RATE"},
  { IOCTL_SERIAL_SET_QUEUE_SIZE                          , "IOCTL_SERIAL_SET_QUEUE_SIZE"},
  { IOCTL_SERIAL_SET_LINE_CONTROL                        , "IOCTL_SERIAL_SET_LINE_CONTROL"},
  { IOCTL_SERIAL_SET_BREAK_ON                            , "IOCTL_SERIAL_SET_BREAK_ON"},
  { IOCTL_SERIAL_SET_BREAK_OFF                           , "IOCTL_SERIAL_SET_BREAK_OFF"},
  { IOCTL_SERIAL_IMMEDIATE_CHAR                          , "IOCTL_SERIAL_IMMEDIATE_CHAR"},
  { IOCTL_SERIAL_SET_TIMEOUTS                            , "IOCTL_SERIAL_SET_TIMEOUTS"},
  { IOCTL_SERIAL_GET_TIMEOUTS                            , "IOCTL_SERIAL_GET_TIMEOUTS"},
  { IOCTL_SERIAL_SET_DTR                                 , "IOCTL_SERIAL_SET_DTR"},
  { IOCTL_SERIAL_CLR_DTR                                 , "IOCTL_SERIAL_CLR_DTR"},
  { IOCTL_SERIAL_RESET_DEVICE                            , "IOCTL_SERIAL_RESET_DEVICE"},
  { IOCTL_SERIAL_SET_RTS                                 , "IOCTL_SERIAL_SET_RTS"},
  { IOCTL_SERIAL_CLR_RTS                                 , "IOCTL_SERIAL_CLR_RTS"},
  { IOCTL_SERIAL_SET_XOFF                                , "IOCTL_SERIAL_SET_XOFF"},
  { IOCTL_SERIAL_SET_XON                                 , "IOCTL_SERIAL_SET_XON"},
  { IOCTL_SERIAL_GET_WAIT_MASK                           , "IOCTL_SERIAL_GET_WAIT_MASK"},
  { IOCTL_SERIAL_SET_WAIT_MASK                           , "IOCTL_SERIAL_SET_WAIT_MASK"},
  { IOCTL_SERIAL_WAIT_ON_MASK                            , "IOCTL_SERIAL_WAIT_ON_MASK"},
  { IOCTL_SERIAL_PURGE                                   , "IOCTL_SERIAL_PURGE"},
  { IOCTL_SERIAL_GET_BAUD_RATE                           , "IOCTL_SERIAL_GET_BAUD_RATE"},
  { IOCTL_SERIAL_GET_LINE_CONTROL                        , "IOCTL_SERIAL_GET_LINE_CONTROL"},
  { IOCTL_SERIAL_GET_CHARS                               , "IOCTL_SERIAL_GET_CHARS"},
  { IOCTL_SERIAL_SET_CHARS                               , "IOCTL_SERIAL_SET_CHARS"},
  { IOCTL_SERIAL_GET_HANDFLOW                            , "IOCTL_SERIAL_GET_HANDFLOW"},
  { IOCTL_SERIAL_SET_HANDFLOW                            , "IOCTL_SERIAL_SET_HANDFLOW"},
  { IOCTL_SERIAL_GET_MODEMSTATUS                         , "IOCTL_SERIAL_GET_MODEMSTATUS"},
  { IOCTL_SERIAL_GET_COMMSTATUS                          , "IOCTL_SERIAL_GET_COMMSTATUS"},
  { IOCTL_SERIAL_XOFF_COUNTER                            , "IOCTL_SERIAL_XOFF_COUNTER"},
  { IOCTL_SERIAL_GET_PROPERTIES                          , "IOCTL_SERIAL_GET_PROPERTIES"},
  { IOCTL_SERIAL_GET_DTRRTS                              , "IOCTL_SERIAL_GET_DTRRTS"},
  { IOCTL_SERIAL_LSRMST_INSERT                           , "IOCTL_SERIAL_LSRMST_INSERT"},
  { IOCTL_SERENUM_EXPOSE_HARDWARE                        , "IOCTL_SERENUM_EXPOSE_HARDWARE"},
  { IOCTL_SERENUM_REMOVE_HARDWARE                        , "IOCTL_SERENUM_REMOVE_HARDWARE"},
  { IOCTL_SERENUM_PORT_DESC                              , "IOCTL_SERENUM_PORT_DESC"},
  { IOCTL_SERENUM_GET_PORT_NAME                          , "IOCTL_SERENUM_GET_PORT_NAME"},
  { IOCTL_SERIAL_CONFIG_SIZE                             , "IOCTL_SERIAL_CONFIG_SIZE"},
  { IOCTL_SERIAL_GET_COMMCONFIG                          , "IOCTL_SERIAL_GET_COMMCONFIG"},
  { IOCTL_SERIAL_SET_COMMCONFIG                          , "IOCTL_SERIAL_SET_COMMCONFIG"},
  { IOCTL_SERIAL_GET_STATS                               , "IOCTL_SERIAL_GET_STATS"},
  { IOCTL_SERIAL_CLEAR_STATS                             , "IOCTL_SERIAL_CLEAR_STATS"},
  { IOCTL_SERIAL_GET_MODEM_CONTROL                       , "IOCTL_SERIAL_GET_MODEM_CONTROL"},
  { IOCTL_SERIAL_SET_MODEM_CONTROL                       , "IOCTL_SERIAL_SET_MODEM_CONTROL"},
  { IOCTL_SERIAL_SET_FIFO_CONTROL                        , "IOCTL_SERIAL_SET_FIFO_CONTROL"},
  { IOCTL_SERIAL_INTERNAL_DO_WAIT_WAKE                   , "IOCTL_SERIAL_INTERNAL_DO_WAIT_WAKE"},
  { IOCTL_SERIAL_INTERNAL_CANCEL_WAIT_WAKE               , "IOCTL_SERIAL_INTERNAL_CANCEL_WAIT_WAKE"},
  { IOCTL_SERIAL_INTERNAL_BASIC_SETTINGS                 , "IOCTL_SERIAL_INTERNAL_BASIC_SETTINGS"},
  { IOCTL_SERIAL_INTERNAL_RESTORE_SETTINGS               , "IOCTL_SERIAL_INTERNAL_RESTORE_SETTINGS"},
  { IOCTL_INTERNAL_SERENUM_REMOVE_SELF                   , "IOCTL_INTERNAL_SERENUM_REMOVE_SELF"},
  { IOCTL_STORAGE_CHECK_VERIFY                           , "IOCTL_STORAGE_CHECK_VERIFY"},
  { IOCTL_STORAGE_CHECK_VERIFY2                          , "IOCTL_STORAGE_CHECK_VERIFY2"},
  { IOCTL_STORAGE_MEDIA_REMOVAL                          , "IOCTL_STORAGE_MEDIA_REMOVAL"},
  { IOCTL_STORAGE_EJECT_MEDIA                            , "IOCTL_STORAGE_EJECT_MEDIA"},
  { IOCTL_STORAGE_LOAD_MEDIA                             , "IOCTL_STORAGE_LOAD_MEDIA"},
  { IOCTL_STORAGE_LOAD_MEDIA2                            , "IOCTL_STORAGE_LOAD_MEDIA2"},
  { IOCTL_STORAGE_RESERVE                                , "IOCTL_STORAGE_RESERVE"},
  { IOCTL_STORAGE_RELEASE                                , "IOCTL_STORAGE_RELEASE"},
  { IOCTL_STORAGE_FIND_NEW_DEVICES                       , "IOCTL_STORAGE_FIND_NEW_DEVICES"},
  { IOCTL_STORAGE_EJECTION_CONTROL                       , "IOCTL_STORAGE_EJECTION_CONTROL"},
  { IOCTL_STORAGE_MCN_CONTROL                            , "IOCTL_STORAGE_MCN_CONTROL"},
  { IOCTL_STORAGE_GET_MEDIA_TYPES                        , "IOCTL_STORAGE_GET_MEDIA_TYPES"},
  { IOCTL_STORAGE_GET_MEDIA_TYPES_EX                     , "IOCTL_STORAGE_GET_MEDIA_TYPES_EX"},
  { IOCTL_STORAGE_RESET_BUS                              , "IOCTL_STORAGE_RESET_BUS"},
  { IOCTL_STORAGE_RESET_DEVICE                           , "IOCTL_STORAGE_RESET_DEVICE"},
  { IOCTL_STORAGE_GET_DEVICE_NUMBER                      , "IOCTL_STORAGE_GET_DEVICE_NUMBER"},
  { IOCTL_STORAGE_PREDICT_FAILURE                        , "IOCTL_STORAGE_PREDICT_FAILURE"},
  { IOCTL_STORAGE_QUERY_PROPERTY                         , "IOCTL_STORAGE_QUERY_PROPERTY"},
  { OBSOLETE_IOCTL_STORAGE_RESET_BUS                     , "OBSOLETE_IOCTL_STORAGE_RESET_BUS"},
  { OBSOLETE_IOCTL_STORAGE_RESET_DEVICE                  , "OBSOLETE_IOCTL_STORAGE_RESET_DEVICE"},
  { IOCTL_TDI_ACCEPT                                     , "IOCTL_TDI_ACCEPT"},
  { IOCTL_TDI_CONNECT                                    , "IOCTL_TDI_CONNECT"},
  { IOCTL_TDI_DISCONNECT                                 , "IOCTL_TDI_DISCONNECT"},
  { IOCTL_TDI_LISTEN                                     , "IOCTL_TDI_LISTEN"},
  { IOCTL_TDI_QUERY_INFORMATION                          , "IOCTL_TDI_QUERY_INFORMATION"},
  { IOCTL_TDI_RECEIVE                                    , "IOCTL_TDI_RECEIVE"},
  { IOCTL_TDI_RECEIVE_DATAGRAM                           , "IOCTL_TDI_RECEIVE_DATAGRAM"},
  { IOCTL_TDI_SEND                                       , "IOCTL_TDI_SEND"},
  { IOCTL_TDI_SEND_DATAGRAM                              , "IOCTL_TDI_SEND_DATAGRAM"},
  { IOCTL_TDI_SET_EVENT_HANDLER                          , "IOCTL_TDI_SET_EVENT_HANDLER"},
  { IOCTL_TDI_SET_INFORMATION                            , "IOCTL_TDI_SET_INFORMATION"},
  { IOCTL_TDI_ASSOCIATE_ADDRESS                          , "IOCTL_TDI_ASSOCIATE_ADDRESS"},
  { IOCTL_TDI_DISASSOCIATE_ADDRESS                       , "IOCTL_TDI_DISASSOCIATE_ADDRESS"},
  { IOCTL_TDI_ACTION                                     , "IOCTL_TDI_ACTION"},
  { IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS                 , "IOCTL_VOLUME_GET_VOLUME_DISK_EXTENTS"},
  { IOCTL_VOLUME_SUPPORTS_ONLINE_OFFLINE                 , "IOCTL_VOLUME_SUPPORTS_ONLINE_OFFLINE"},
  { IOCTL_VOLUME_ONLINE                                  , "IOCTL_VOLUME_ONLINE"},
  { IOCTL_VOLUME_OFFLINE                                 , "IOCTL_VOLUME_OFFLINE"},
  { IOCTL_VOLUME_IS_OFFLINE                              , "IOCTL_VOLUME_IS_OFFLINE"},
  { IOCTL_VOLUME_IS_IO_CAPABLE                           , "IOCTL_VOLUME_IS_IO_CAPABLE"},
  { IOCTL_VOLUME_QUERY_FAILOVER_SET                      , "IOCTL_VOLUME_QUERY_FAILOVER_SET"},
  { IOCTL_VOLUME_QUERY_VOLUME_NUMBER                     , "IOCTL_VOLUME_QUERY_VOLUME_NUMBER"},
  { IOCTL_VOLUME_LOGICAL_TO_PHYSICAL                     , "IOCTL_VOLUME_LOGICAL_TO_PHYSICAL"},
  { IOCTL_VOLUME_PHYSICAL_TO_LOGICAL                     , "IOCTL_VOLUME_PHYSICAL_TO_LOGICAL"},
  { IOCTL_QUERY_DEVICE_POWER_STATE                       , "IOCTL_QUERY_DEVICE_POWER_STATE"},
  { IOCTL_SET_DEVICE_WAKE                                , "IOCTL_SET_DEVICE_WAKE"},
  { IOCTL_CANCEL_DEVICE_WAKE                             , "IOCTL_CANCEL_DEVICE_WAKE"},
  { IOCTL_INTERNAL_PARALLEL_PORT_ALLOCATE                , "IOCTL_INTERNAL_PARALLEL_PORT_ALLOCATE"},
  { IOCTL_INTERNAL_GET_PARALLEL_PORT_INFO                , "IOCTL_INTERNAL_GET_PARALLEL_PORT_INFO"},
  { IOCTL_INTERNAL_PARALLEL_CONNECT_INTERRUPT            , "IOCTL_INTERNAL_PARALLEL_CONNECT_INTERRUPT"},
  { IOCTL_INTERNAL_PARALLEL_DISCONNECT_INTERRUPT         , "IOCTL_INTERNAL_PARALLEL_DISCONNECT_INTERRUPT"},
  { IOCTL_INTERNAL_RELEASE_PARALLEL_PORT_INFO            , "IOCTL_INTERNAL_RELEASE_PARALLEL_PORT_INFO"},
  { IOCTL_INTERNAL_GET_MORE_PARALLEL_PORT_INFO           , "IOCTL_INTERNAL_GET_MORE_PARALLEL_PORT_INFO"},
  { IOCTL_INTERNAL_PARCHIP_CONNECT                       , "IOCTL_INTERNAL_PARCHIP_CONNECT"},
  { IOCTL_INTERNAL_PARALLEL_SET_CHIP_MODE                , "IOCTL_INTERNAL_PARALLEL_SET_CHIP_MODE"},
  { IOCTL_INTERNAL_PARALLEL_CLEAR_CHIP_MODE              , "IOCTL_INTERNAL_PARALLEL_CLEAR_CHIP_MODE"},
  { IOCTL_INTERNAL_GET_PARALLEL_PNP_INFO                 , "IOCTL_INTERNAL_GET_PARALLEL_PNP_INFO"},
  { IOCTL_INTERNAL_INIT_1284_3_BUS                       , "IOCTL_INTERNAL_INIT_1284_3_BUS"},
  { IOCTL_INTERNAL_SELECT_DEVICE                         , "IOCTL_INTERNAL_SELECT_DEVICE"},
  { IOCTL_INTERNAL_DESELECT_DEVICE                       , "IOCTL_INTERNAL_DESELECT_DEVICE"},
  { IOCTL_INTERNAL_PARCLASS_CONNECT                      , "IOCTL_INTERNAL_PARCLASS_CONNECT"},
  { IOCTL_INTERNAL_PARCLASS_DISCONNECT                   , "IOCTL_INTERNAL_PARCLASS_DISCONNECT"},
  { IOCTL_INTERNAL_DISCONNECT_IDLE                       , "IOCTL_INTERNAL_DISCONNECT_IDLE"},
  { IOCTL_INTERNAL_LOCK_PORT                             , "IOCTL_INTERNAL_LOCK_PORT"},
  { IOCTL_INTERNAL_UNLOCK_PORT                           , "IOCTL_INTERNAL_UNLOCK_PORT"},
  { IOCTL_INTERNAL_PARALLEL_PORT_FREE                    , "IOCTL_INTERNAL_PARALLEL_PORT_FREE"},
  { IOCTL_INTERNAL_PARDOT3_CONNECT                       , "IOCTL_INTERNAL_PARDOT3_CONNECT"},
  { IOCTL_INTERNAL_PARDOT3_DISCONNECT                    , "IOCTL_INTERNAL_PARDOT3_DISCONNECT"},
  { IOCTL_INTERNAL_PARDOT3_RESET                         , "IOCTL_INTERNAL_PARDOT3_RESET"},
  { IOCTL_INTERNAL_PARDOT3_SIGNAL                        , "IOCTL_INTERNAL_PARDOT3_SIGNAL"},
  { IOCTL_INTERNAL_REGISTER_FOR_REMOVAL_RELATIONS        , "IOCTL_INTERNAL_REGISTER_FOR_REMOVAL_RELATIONS"},
  { IOCTL_INTERNAL_UNREGISTER_FOR_REMOVAL_RELATIONS      , "IOCTL_INTERNAL_UNREGISTER_FOR_REMOVAL_RELATIONS"},
  { IOCTL_PF_SET_EXTENSION_POINTER                       , "IOCTL_PF_SET_EXTENSION_POINTER"},
  { IOCTL_BATTERY_QUERY_TAG                              , "IOCTL_BATTERY_QUERY_TAG"},
  { IOCTL_BATTERY_QUERY_INFORMATION                      , "IOCTL_BATTERY_QUERY_INFORMATION"},
  { IOCTL_BATTERY_SET_INFORMATION                        , "IOCTL_BATTERY_SET_INFORMATION"},
  { IOCTL_BATTERY_QUERY_STATUS                           , "IOCTL_BATTERY_QUERY_STATUS"},
  { IOCTL_THERMAL_QUERY_INFORMATION                      , "IOCTL_THERMAL_QUERY_INFORMATION"},
  { IOCTL_THERMAL_SET_COOLING_POLICY                     , "IOCTL_THERMAL_SET_COOLING_POLICY"},
  { IOCTL_RUN_ACTIVE_COOLING_METHOD                      , "IOCTL_RUN_ACTIVE_COOLING_METHOD"},
  { IOCTL_QUERY_LID                                      , "IOCTL_QUERY_LID"},
  { IOCTL_NOTIFY_SWITCH_EVENT                            , "IOCTL_NOTIFY_SWITCH_EVENT"},
  { IOCTL_GET_SYS_BUTTON_CAPS                            , "IOCTL_GET_SYS_BUTTON_CAPS"},
  { IOCTL_GET_SYS_BUTTON_EVENT                           , "IOCTL_GET_SYS_BUTTON_EVENT"},
  { IOCTL_SCSISCAN_CMD                                   , "IOCTL_SCSISCAN_CMD"},
  { IOCTL_SCSISCAN_LOCKDEVICE                            , "IOCTL_SCSISCAN_LOCKDEVICE"},
  { IOCTL_SCSISCAN_UNLOCKDEVICE                          , "IOCTL_SCSISCAN_UNLOCKDEVICE"},
  { IOCTL_SCSISCAN_SET_TIMEOUT                           , "IOCTL_SCSISCAN_SET_TIMEOUT"},
  { IOCTL_SCSISCAN_GET_INFO                              , "IOCTL_SCSISCAN_GET_INFO"},
  { IOCTL_SWENUM_INSTALL_INTERFACE                       , "IOCTL_SWENUM_INSTALL_INTERFACE"},
  { IOCTL_SWENUM_REMOVE_INTERFACE                        , "IOCTL_SWENUM_REMOVE_INTERFACE"},
  { IOCTL_SWENUM_GET_BUS_ID                              , "IOCTL_SWENUM_GET_BUS_ID"},
  { IOCTL_INTERNAL_USB_SUBMIT_URB                        , "IOCTL_INTERNAL_USB_SUBMIT_URB"},
  { IOCTL_INTERNAL_USB_RESET_PORT                        , "IOCTL_INTERNAL_USB_RESET_PORT"},
  { IOCTL_INTERNAL_USB_GET_ROOTHUB_PDO                   , "IOCTL_INTERNAL_USB_GET_ROOTHUB_PDO"},
  { IOCTL_INTERNAL_USB_GET_PORT_STATUS                   , "IOCTL_INTERNAL_USB_GET_PORT_STATUS"},
  { IOCTL_INTERNAL_USB_ENABLE_PORT                       , "IOCTL_INTERNAL_USB_ENABLE_PORT"},
  { IOCTL_INTERNAL_USB_GET_HUB_COUNT                     , "IOCTL_INTERNAL_USB_GET_HUB_COUNT"},
  { IOCTL_INTERNAL_USB_CYCLE_PORT                        , "IOCTL_INTERNAL_USB_CYCLE_PORT"},
  { IOCTL_INTERNAL_USB_GET_HUB_NAME                      , "IOCTL_INTERNAL_USB_GET_HUB_NAME"},
  { IOCTL_INTERNAL_USB_GET_BUS_INFO                      , "IOCTL_INTERNAL_USB_GET_BUS_INFO"},
  { IOCTL_INTERNAL_USB_GET_CONTROLLER_NAME               , "IOCTL_INTERNAL_USB_GET_CONTROLLER_NAME"},
  { IOCTL_INTERNAL_USB_GET_BUSGUID_INFO                  , "IOCTL_INTERNAL_USB_GET_BUSGUID_INFO"},
  { IOCTL_INTERNAL_USB_GET_PARENT_HUB_INFO               , "IOCTL_INTERNAL_USB_GET_PARENT_HUB_INFO"},
  { IOCTL_USB_HCD_GET_STATS_1                            , "IOCTL_USB_HCD_GET_STATS_1"},
  { IOCTL_USB_HCD_GET_STATS_2                            , "IOCTL_USB_HCD_GET_STATS_2"},
  { IOCTL_USB_DIAGNOSTIC_MODE_ON                         , "IOCTL_USB_DIAGNOSTIC_MODE_ON"},
  { IOCTL_USB_DIAGNOSTIC_MODE_OFF                        , "IOCTL_USB_DIAGNOSTIC_MODE_OFF"},
  { IOCTL_USB_GET_ROOT_HUB_NAME                          , "IOCTL_USB_GET_ROOT_HUB_NAME"},
  { IOCTL_GET_HCD_DRIVERKEY_NAME                         , "IOCTL_GET_HCD_DRIVERKEY_NAME"},
  { IOCTL_USB_HCD_DISABLE_PORT                           , "IOCTL_USB_HCD_DISABLE_PORT"},
  { IOCTL_USB_HCD_ENABLE_PORT                            , "IOCTL_USB_HCD_ENABLE_PORT"},
  { IOCTL_USB_GET_NODE_INFORMATION                       , "IOCTL_USB_GET_NODE_INFORMATION"},
  { IOCTL_USB_GET_NODE_CONNECTION_INFORMATION            , "IOCTL_USB_GET_NODE_CONNECTION_INFORMATION"},
  { IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION        , "IOCTL_USB_GET_DESCRIPTOR_FROM_NODE_CONNECTION"},
  { IOCTL_USB_GET_NODE_CONNECTION_NAME                   , "IOCTL_USB_GET_NODE_CONNECTION_NAME"},
  { IOCTL_USB_DIAG_IGNORE_HUBS_ON                        , "IOCTL_USB_DIAG_IGNORE_HUBS_ON"},
  { IOCTL_USB_DIAG_IGNORE_HUBS_OFF                       , "IOCTL_USB_DIAG_IGNORE_HUBS_OFF"},
  { IOCTL_USB_GET_NODE_CONNECTION_DRIVERKEY_NAME         , "IOCTL_USB_GET_NODE_CONNECTION_DRIVERKEY_NAME"},
  { IOCTL_INTERNAL_USB_SUBMIT_URB                        , "IOCTL_INTERNAL_USB_SUBMIT_URB"},
  { IOCTL_GET_VERSION                                    , "IOCTL_GET_VERSION"},
  { IOCTL_CANCEL_IO                                      , "IOCTL_CANCEL_IO"},
  { IOCTL_WAIT_ON_DEVICE_EVENT                           , "IOCTL_WAIT_ON_DEVICE_EVENT"},
  { IOCTL_READ_REGISTERS                                 , "IOCTL_READ_REGISTERS"},
  { IOCTL_WRITE_REGISTERS                                , "IOCTL_WRITE_REGISTERS"},
  { IOCTL_GET_CHANNEL_ALIGN_RQST                         , "IOCTL_GET_CHANNEL_ALIGN_RQST"},
  { IOCTL_GET_DEVICE_DESCRIPTOR                          , "IOCTL_GET_DEVICE_DESCRIPTOR"},
  { IOCTL_RESET_PIPE                                     , "IOCTL_RESET_PIPE"},
  { IOCTL_GET_USB_DESCRIPTOR                             , "IOCTL_GET_USB_DESCRIPTOR"},
  { IOCTL_SEND_USB_REQUEST                               , "IOCTL_SEND_USB_REQUEST"},
  { IOCTL_GET_PIPE_CONFIGURATION                         , "IOCTL_GET_PIPE_CONFIGURATION"},
  { IOCTL_SMARTCARD_POWER                                , "IOCTL_SMARTCARD_POWER"},
  { IOCTL_SMARTCARD_GET_ATTRIBUTE                        , "IOCTL_SMARTCARD_GET_ATTRIBUTE"},
  { IOCTL_SMARTCARD_SET_ATTRIBUTE                        , "IOCTL_SMARTCARD_SET_ATTRIBUTE"},
  { IOCTL_SMARTCARD_CONFISCATE                           , "IOCTL_SMARTCARD_CONFISCATE"},
  { IOCTL_SMARTCARD_TRANSMIT                             , "IOCTL_SMARTCARD_TRANSMIT"},
  { IOCTL_SMARTCARD_EJECT                                , "IOCTL_SMARTCARD_EJECT"},
  { IOCTL_SMARTCARD_SWALLOW                              , "IOCTL_SMARTCARD_SWALLOW"},
  { IOCTL_SMARTCARD_IS_PRESENT                           , "IOCTL_SMARTCARD_IS_PRESENT"},
  { IOCTL_SMARTCARD_IS_ABSENT                            , "IOCTL_SMARTCARD_IS_ABSENT"},
  { IOCTL_SMARTCARD_SET_PROTOCOL                         , "IOCTL_SMARTCARD_SET_PROTOCOL"},
  { IOCTL_SMARTCARD_GET_STATE                            , "IOCTL_SMARTCARD_GET_STATE"},
  { IOCTL_SMARTCARD_GET_LAST_ERROR                       , "IOCTL_SMARTCARD_GET_LAST_ERROR"},
  { IOCTL_SMARTCARD_GET_PERF_CNTR                        , "IOCTL_SMARTCARD_GET_PERF_CNTR"},
*/

  {0,NULL}
};

char* device_str(DWORD device_code)
{
  for(int i=0; device_array[i].device_str != NULL; i++)
    if (device_array[i].device_code == device_code)
      return device_array[i].device_str;
  static char s[16];
  sprintf(s, "0x%04X", device_code);
  return s;
}//device_str

char* ctl_str(DWORD ctl_code)
{
  for(int i=0; ctl_array[i].ctl_str != NULL; i++)
    if (ctl_array[i].ctl_code == ctl_code)
      return ctl_array[i].ctl_str;
  return "?";
}//ctl_str

void log(char* fmt, ...)
{
  va_list va;
  va_start(va, fmt);
  static char s[1024];
  vsnprintf(s, sizeof(s)-1, fmt, va);
  va_end(va);

  if (GetFileType(GetStdHandle(STD_OUTPUT_HANDLE))==FILE_TYPE_CHAR)
  if (strlen(s) >= 80+1) // +1 coz \n
  {
    s[77]='.';
    s[78]='.';
    s[79]='.';
    s[80]=0;
  }

  printf("%s", s);
}//log

int main(int argc, char* argv[])
{
  if (argc<=1)
  {
    log("syntax: IOCODE <ctl_code> [...]\n");
    exit(0);
  }

  for(int i=1; i<argc; i++)
  {

    DWORD ctl_code;
    sscanf(argv[i], "%X", &ctl_code);

    DWORD device      = (ctl_code & 0xFFFF0000) >> 16;
    DWORD access      = (ctl_code & 0x0000C000) >> 14;
    DWORD function    = (ctl_code & 0x00003FFC) >> 2;
    DWORD method      = (ctl_code & 0x00000003);

    char str[1024];
    sprintf(str, "CTL_CODE( %s, 0x%04X, %s, %s )",
      device_str(device),
      function,
      method_str[method],
      access_str[access] );

    log("+----------+-----hex----+-----------------------------------------------------+\n");
    log("| code     | 0x%08X |         %-43s |\n", ctl_code, ctl_str(ctl_code));
    log("+----------+------------+--dec--+---------------------------------------------+\n");
    log("| device   | 0x%08X | %5i | %-43s |\n", device, device, device_str(device));
    log("+----------+------------+-------+---------------------------------------------+\n");
    log("| function | 0x%08X | %5i | %-43s |\n", function, function, "");
    log("+----------+------------+-------+---------------------------------------------+\n");
    log("| method   | 0x%08X | %5i | %-43s |\n", method, method, method_str[method]);
    log("+----------+------------+-------+---------------------------------------------+\n");
    log("| access   | 0x%08X | %5i | %-43s |\n", access, access, access_str[access]);
    log("+----------+------------+-------+---------------------------------------------+\n");
    log("| %-75s |\n", str);
    log("+-----------------------------------------------------------------------------+\n");

    char*s = ctl_str(ctl_code);
    if (s[0]=='?')
      s = str;
    int  l = strlen(s)+1;

    assert(OpenClipboard(NULL));
    assert(EmptyClipboard());
    HANDLE hMem = GlobalAlloc(GMEM_MOVEABLE|GMEM_DDESHARE, l);
    assert(hMem != NULL);
    LPVOID ptr = GlobalLock(hMem);
    assert(ptr != NULL);
    memcpy(ptr, s, l);
    assert(SetClipboardData(CF_OEMTEXT, hMem)!=NULL);
    //printf("%i", GetLastError());
    assert(CloseClipboard());
    //assert(GlobalUnlock(hMem));

  }//for i

}//main
