
MAXBUFSIZE              equ     8192

                        model   tiny
                        p386

                        locals  @@

                        .code

                        org     100h
start:
                        jmp     init

int29:                  call    savekey

exit29:                 db      0eah
old29                   dd      ?

savekey:                push    bx
                        mov     bx, cs:bufsize
                        cmp     bx, MAXBUFSIZE
                        jae     @@1
                        mov     cs:buf[bx], al
                        inc     cs:bufsize
@@1:                    pop     bx
                        ret

in21                    db      0

int21:
                        cmp     cs:in21, 0
                        jne     exit21
                        inc     cs:in21

                        call    dumpbuf

                        dec     cs:in21

exit21:                 db      0eah
old21                   dd      ?

dumpbuf:                pusha
                        push    ds

                        push    cs
                        pop     ds

                        cmp     bufsize, 0
                        je      @@exit

                        mov     ax, 3D02h
                        mov     dx, argv[0*2]
                        int     21h
                        jnc     @@1

                        mov     ah, 3ch
                        xor     cx, cx
                        int     21h
                        jc      @@exit

@@1:                    xchg    bx, ax

                        mov     ax, 4202h
                        cwd
                        xor     cx, cx
                        int     21h

                        mov     ah, 40h
                        lea     dx, buf
                        mov     cx, bufsize
                        int     21h

                        mov     ah, 3eh
                        int     21h

                        mov     bufsize, 0

@@exit:                 pop     ds
                        popa
                        ret

init:                   mov     ah, 9
                        lea     dx, msg_title
                        int     21h

                        call    parse_cmdline

                        lea     dx, msg_help
                        cmp     argc, 2
                        jb      msgexit

                        lea     sp, endofstack

                        mov     ah, 4Ah
                        mov     bx, memory
                        int     21h

                        mov     ah, 9
                        lea     dx, msg_0
                        int     21h
                        mov     si, argv[0*2]
                        call    asciiz
                        mov     ah, 9
                        lea     dx, msg_3
                        int     21h

                        mov     ah, 9
                        lea     dx, msg_1
                        int     21h
                        mov     si, argv[1*2]
                        call    asciiz
                        mov     ah, 9
                        lea     dx, msg_3
                        int     21h

                        mov     ah, 9
                        lea     dx, msg_2
                        int     21h
                        mov     si, argv[2*2]
                        or      si, si
                        jz      @@0
                        call    asciiz
@@0:                    mov     ah, 9
                        lea     dx, msg_3
                        int     21h

                        mov     cs1, cs
                        mov     si, argv[2*2]
                        or      si, si
                        jz      @@3
                        sub     si, offset cmdline-80h+1
                        mov     paramsptr, si
                        mov     di, si
                        inc     si
                        xor     cx, cx
                        inc     si
@@2:                    inc     cx
                        lodsb
                        cmp     al, 13
                        jne     @@2
                        mov     [di], cl
@@3:
                        mov     ah, 9
                        lea     dx, msg_start
                        int     21h

                        mov     ax, 3521h
                        int     21h
                        mov     old21.word ptr 0, bx
                        mov     old21.word ptr 2, es
                        mov     ax, 2521h
                        lea     dx, int21
                        int     21h

                        mov     ax, 3529h
                        int     21h
                        mov     old29.word ptr 0, bx
                        mov     old29.word ptr 2, es
                        mov     ax, 2529h
                        lea     dx, int29
                        int     21h

                        push    cs
                        pop     es

                        mov     ax, 4b00h
                        lea     bx, execparams
                        mov     dx, argv[1*2]
                        int     21h

                        pushf

                        mov     ax, 2529h
                        lds     dx, cs:old29
                        int     21h
                        mov     ax, 2521h
                        lds     dx, cs:old21
                        int     21h

                        popf

                        push    cs
                        pop     ds

                        lea     dx, msg_error
                        jc      @@1
                        lea     dx, msg_end
@@1:

msgexit:                mov     ah, 9
                        int     21h

                        mov     ax, 4c00h
                        int     21h

parse_cmdline:          mov     si, 0080h
                        lea     di, cmdline
                        mov     cx, 128
                        rep     movsb
                        lea     si, cmdline+1
                        lea     di, argv
@@1:                    mov     dx, si
                        lodsb
                        cmp     al, 13
                        je      @@5
                        cmp     al, 9
                        je      @@1
                        cmp     al, 32
                        je      @@1
@@3:                    lodsb
                        cmp     al, 13
                        je      @@4
                        cmp     al, 9
                        je      @@4
                        cmp     al, 32
                        jne     @@3
@@4:                    sub     [si-1], al
                        inc     argc
                        xchg    dx, ax
                        stosw
                        cmp     dl, 13
                        jne     @@1
@@5:                    ret

asciiz:                 lodsb
                        or      al, al
                        jz      @@1
                        int     29h
                        jmp     asciiz
@@1:                    ret

msg_title               db      'SCRGRAB  build 001  z0mbie.cjb.net',13,10,'$'
msg_tsr                 db      ' resident',13,10,'$'
msg_help                db      'syntax:',13,10
                        db      '  SCRGRAB outfile execfile [execparams]',13,10,'$'
msg_0                   db      'grab to: [$'
msg_1                   db      'program: [$'
msg_2                   db      'cmdline: [$'
msg_3                   db      ']',13,10,'$'
msg_start               db      'executing...',13,10
                        db      '-------------------------------------------------------------------------------',13,10,'$'
msg_end                 db      '-------------------------------------------------------------------------------',13,10
                        db      'done.',13,10,'$'
msg_error               db      '-------------------------------------------------------------------------------',13,10
                        db      'ERROR',13,10,'$'

execparams:             dw      0
paramsptr               dw      noparams
cs1                     dw      ?
                        dw      10 dup (0)

noparams                db      00h,0Dh

cmdline                 db      128 dup (0)
argc                    dw      0
argv                    dw      32 dup (0)

bufsize                 dw      0
buf                     db      MAXBUFSIZE dup (0)

                        even
                        db      4096/8 dup ('STACKxxx')
endofstack:

memory                  equ     ($-start+256+15)/16

                        end     start
