
;----------------------------------------------------------------------------
; RSA-encryption library (128-bit)            (x) 2000 Z0MBiE, z0mbie.cjb.net
;----------------------------------------------------------------------------

; version 5.50

; * fixed precision (128-bit)
; * 32-bit exponent
; * small code, slow -- use for signature verification

;----------------------------------------------------------------------------

; action: [EDI] = ([EDI] ^ EAX) % [ESI]
; input:  [EDI] = base = result
;         [ESI] = modulus

modexp55:               pusha

                        xchg    ebp, eax       ; EBP = exponent

                        push    0 0 0 1        ; [ESP] = 1

__expcycle:             shr     ebp, 1         ; if (exp.bit[n]==1)
                        jnc     __exp_nobit

                        pop     eax            ; dcba = [ESP]
                        pop     ebx
                        pop     ecx
                        pop     edx

                        call    __modmul       ; dcba = (dcba * [EDI]) % [ESI]

                        push    edx            ; [ESP] = dcba
                        push    ecx
                        push    ebx
                        push    eax

__exp_nobit:            mov     eax, [edi]     ; dcba = [EDI]
                        mov     ebx, [edi+4]
                        mov     ecx, [edi+8]
                        mov     edx, [edi+12]

                        call    __modmul       ; dcba = (dcba * [EDI]) % [ESI]

                        push    edi
                        stosd                  ; [EDI] = dcba
                        xchg    ebx, eax
                        stosd
                        xchg    ecx, eax
                        stosd
                        xchg    edx, eax
                        stosd
                        pop     edi

                        or      ebp, ebp
                        jnz     __expcycle

                        pop     eax            ; [EDI] = [ESP]
                        stosd
                        pop     eax
                        stosd
                        pop     eax
                        stosd
                        pop     eax
                        stosd

                        popa
                        retn

; action: dcba = (dcba * [EDI]) % [ESI]

__modmul:               pusha
                        xor     eax, eax       ; dcba = 0
                        xor     ebx, ebx
                        xor     ecx, ecx
                        xor     edx, edx
                        push    ebp
                        push    127            ; cycle: EBP = 127 downto 0
                        pop     ebp            ;
__mul_cycle:            shl     eax, 1         ; dcba <<= 1
                        rcl     ebx, 1
                        rcl     ecx, 1
                        rcl     edx, 1
                        call    __cmpsub       ; if (CF:dcba>=[ESI]) dcba-=[ESI]
                        mov     edi, [esp+4+0*4] ; pusha.edi
                        bt      [edi], ebp     ; if [EDI].bit[EBP]==1
                        jnc     __mul_skip
                        add     eax, [esp+4+7*4] ; pusha.eax
                        adc     ebx, [esp+4+4*4] ; pusha.ebx
                        adc     ecx, [esp+4+6*4] ; pusha.ecx
                        adc     edx, [esp+4+5*4] ; pusha.edx
                        call    __cmpsub       ; if (CF:dcba>=[ESI]) dcba-=[ESI]
__mul_skip:             dec     ebp            ; cycle
                        jns     __mul_cycle
                        pop     ebp
                        pop     edi            ; restore EDI/ESI after PUSHA
                        pop     esi
                        push    ecx
                        push    ecx
__rt:                   add     esp, 32
                        retn
; action: if (CF:dcba >= [ESI]) { dcba -= [ESI] }
__cmpsub:               push    0              ; EDI = CF
                        pop     edi
                        rcl     edi, 1
                        pusha
                        mov     esi, [esp+32+4+4+1*4]  ; pusha.esi
                        sub     eax, [esi]     ; dcba -= [ESI]
                        sbb     ebx, [esi+4]
                        sbb     ecx, [esi+8]
                        sbb     edx, [esi+12]
                        sbb     edi, 0         ; CF
                        jnc     __rt
                        popa                   ; CF==1 -- return unchanged
                        retn

;----------------------------------------------------------------------------
