{
font editor
}

{$A+,B-,D+,E-,F-,G+,I-,L+,N+,O-,P-,Q-,R-,S-,T-,V-,X+,Y+}
{$M 16384,0,655360}

uses crt, dos, graph;

procedure EgaVgaDriverProc; external;
{$L EGAVGA.OBJ}

const
  gd : integer = vga;
  gm : integer = vgahi;

const
  max_font_size = 32;

var
  filename : string;
  font,copy,temp,back : array[byte] of array[0..max_font_size-1] of byte;
  fontsize : word;

  font_x,
  font_y : word;

  window : integer;
  cycle : boolean;
  automove_dir : (none,left,right,up,down);
  automove_mode : boolean;

  block_s, block_e : integer;

  edit_n,
  edit_x,
  edit_y : integer;

procedure load(ask : boolean);
  var
    s : string;
    f : file;
    i : integer;
  begin
    if ask then
    begin
      write('load font [',filename,']: '); readln(s);
      if s <> '' then filename := s;
    end;

    assign(f, filename);
    filemode := 0;
    reset(f,1);
    filemode := 2;
    if ioresult <> 0 then
    begin
      writeln('- file not found');
      halt;
    end;
    fontsize := filesize(f);
    if fontsize > sizeof(font) then
    begin
      writeln('- file size too large');
      halt;
    end;
    if fontsize < 8*256 then
    begin
      writeln('- file size too small');
      halt;
    end;
    if fontsize mod 256 <> 0 then
    begin
      writeln('- invalid file size');
      halt;
    end;
    font_y := fontsize div 256;
    for i := 0 to 255 do
      blockread(f, font[i], font_y);
    close(f);

    move(font, copy, sizeof(copy));
  end;

procedure save;
  var
    c : char;
    s : string;
    f : file;
    i,j : integer;
  begin
    asm
      push    ds
      pop     es
      mov     si, offset font
      mov     di, offset copy
      mov     cx, 256*max_font_size
      cld
      rep     cmpsb
      mov     i, 0
      jne     @@1
      mov     i, 1
@@1:
    end;
    if i = 1 then exit;

    write('save font? (Y/N): ');
    c := readkey;
    if c in ['y','Y',#13] then
      writeln('Yes')
    else begin
      writeln('No');
      exit;
    end;
    write('save font [',filename,']: '); readln(s);

    if s <> '' then filename := s;

    assign(f, filename);
    rewrite(f,1);
    for i := 0 to 255 do
      blockwrite(f, font[i], font_y);
    close(f);

    move(font, copy, sizeof(copy));
  end;

const
  c0 = 15;

  r1 = 2;
  r2 = 1;
  c1 = 3;
  c2 = 0;
  c3 = 15;
  c7 = 14;
  c2b = 1;
  c3b = 11;

  r3 = 2;
  r4 = 1;
  c6 = 3;
  c4 = 0;
  c5 = 15;
  c8 = 12;
  q1 = 1;
  q2 = 1;

  r5 = 2;
  c9 = 3;
  c10 = 0;
  c11 = 15;

  w1 = 0;
  w2 = 15;
  q3 = 2;

var
  x1,y1,x2,y2,x3,y3,x4,y4 : integer;

procedure init_vars;
  begin

    x1 := (getmaxx+1) div 4 - 16*(font_x+r2) div 2;
    y1 := (getmaxy+1) div 2 - 16*(font_y+r2) div 2;

    x3 := 20;
    y3 := 20;
    x2 := (getmaxx+1)*3 div 5 - font_x*(x3+r4) div 2;
    y2 := (getmaxy+1)   div 2 - font_y*(y3+r4) div 2;

    x4 := 10;
    y4 := getmaxy-50;

  end;

procedure draw_screen;
  var
    x : integer;
  begin
    setfillstyle(solidfill, 0);
    bar(0,0,639,479);

    setcolor(c0);
    settextstyle(defaultfont, horizdir, 1);
    outtextxy(0, 0*10,'S=set block start');
    outtextxy(0, 1*10,'E=set block end');
    outtextxy(0, 2*10,'A=select all');
    outtextxy(0, 3*10,'C=copy block');
    outtextxy(0, 4*10,'Z=zero block/char');
    outtextxy(0, 5*10,'I=inverse block/char');
    outtextxy(0, 6*10,'TAB=switch window');
    outtextxy(0, 7*10,'BACKSPACE=undo/redo');
    outtextxy(0, 8*10,'F2=save font/save as');
    outtextxy(0, 9*10,'F3=reload font/load new');

    x := getmaxx div 3;
    outtextxy(x, 0*10,'L=move block/char left');
    outtextxy(x, 1*10,'R=move block/char right');
    outtextxy(x, 2*10,'U=move block/char up');
    outtextxy(x, 3*10,'D=move block/char down');
    outtextxy(x, 4*10,'X=turn cycle moving on/off');
    outtextxy(x, 5*10,'F5=turn automoving on/off');
    outtextxy(x, 6*10,'+=increase font size');
    outtextxy(x, 7*10,'-=decrease font size');

    x := getmaxx*2 div 3;
    outtextxy(x, 0*10,'M=import characters');
    outtextxy(x, 1*10,'P=export characters');

    setfillstyle(solidfill, c1);
    bar(x1-r1,y1-r1,
        x1+(font_x+r2)*16-r2-1+r1,
        y1+(font_y+r2)*16-r2-1+r1);

    setfillstyle(solidfill, c6);
    bar(x2-r3,
        y2-r3,
        x2+font_x*(x3+r4)-r4-1+r3+byte(font_x=9)*q2,
        y2+font_y*(y3+r4)-r4-1+r3);
  end;

procedure draw_char_table(s,e : integer);
  var
    i,j, c, x,y : integer;
  begin
    for i := s to e do
    begin
      for y := 0 to font_y-1 do
      for x := 0 to font_x-1 do
      begin
        if x < 8 then j := x else j := 7;

        if (i < block_s) or (i > block_e) then begin

          c := c2 + (font[i][y] shr (7-j) and 1)*(c3-c2);
          if (x = 8) and ((i < $C0) or (i > $DF)) then c := c2;

        end else begin

          c := c2b + (font[i][y] shr (7-j) and 1)*(c3b-c2b);
          if (x = 8) and ((i < $C0) or (i > $DF)) then c := c2b;

        end;

        putpixel(x1+(i mod 16)*(font_x+r2)+x,
                 y1+(i div 16)*(font_y+r2)+y,
                 c);
      end;
    end;
  end;

procedure draw_editing_char;
  var
    i,j, c, x,y : integer;
  begin
    i := edit_n;
    for y := 0 to font_y-1 do
    for x := 0 to font_x-1 do
    begin
      if x < 8 then j := x else j := 7;
      c := c4 + (font[i][y] shr (7-j) and 1)*(c5-c4);
      if (x = 8) and ((i < $C0) or (i > $DF)) then c := c4;

      setfillstyle(solidfill, c4);
      bar(x2+x*(x3+r4)+byte(x=8)*q2,
          y2+y*(y3+r4),
          x2+x*(x3+r4)+x3-1+byte(x=8)*q2,
          y2+y*(y3+r4)+y3-1);

      setfillstyle(solidfill, c);
      bar(x2+x*(x3+r4)+q1+byte(x=8)*q2,
          y2+y*(y3+r4)+q1,
          x2+x*(x3+r4)+x3-1-q1+byte(x=8)*q2,
          y2+y*(y3+r4)+y3-1-q1);

    end;
  end;

procedure draw_border(i,j : integer);
  var
    c : integer;
  begin
    if j = 0 then setcolor(c1) else setcolor(c7);

    rectangle(x1+(i mod 16)*(font_x+r2)-1,
              y1+(i div 16)*(font_y+r2)-1,
              x1+(i mod 16)*(font_x+r2)+font_x-1+1,
              y1+(i div 16)*(font_y+r2)+font_y-1+1);

    if j = 0 then setcolor(c6) else setcolor(c8);

    rectangle(x2+edit_x*(x3+r4)-1+byte(edit_x=8)*q2,
              y2+edit_y*(y3+r4)-1,
              x2+edit_x*(x3+r4)+x3-1+1+byte(edit_x=8)*q2,
              y2+edit_y*(y3+r4)+y3-1+1);

  end;

function FStr(L : Longint) : String;
  var
    S : String;
  begin
    Str(L, S);
    FStr := S;
  end;

procedure draw_status;
  var
    s : string;
    x5,y5 : integer;
  begin
    s := 'cycle: ';
    if cycle then s := s + 'ON ' else s := s + 'OFF';
    s := s + 'automove: ';
    if automove_mode then s := s + 'ON ' else s := s + 'OFF';
    s := s + ' file: '+filename+' size: '+fstr(font_x)+'x'+fstr(font_y);

    x5 := (length(s)+1)*8;
    y5 := 16;

    setfillstyle(solidfill, c9);
    bar(x4-r5,y4-r5,x4+x5+r5,y4+y5+r5);
    setfillstyle(solidfill, c10);
    bar(x4,y4,x4+x5,y4+y5);
    setcolor(c11);
    outtextxy(x4+4,y4+4,s);
  end;

procedure draw_window_border;
  begin
    if window = 1 then setcolor(w1) else setcolor(w2);

    rectangle(x1-r1-q3,
              y1-r1-q3,
              x1+(font_x+r2)*16-r2-1+r1+q3,
              y1+(font_y+r2)*16-r2-1+r1+q3);

    if window = 2 then setcolor(w1) else setcolor(w2);

    rectangle(x2-r3-q3,
              y2-r3-q3,
              x2+font_x*(x3+r4)-r4-1+r3+byte(font_x=9)*q2+q3,
              y2+font_y*(y3+r4)-r4-1+r3+q3);
  end;

procedure draw_all;
  begin
    draw_screen;
    draw_status;
    draw_char_table(0,255);
    draw_editing_char;
    draw_window_border;
  end;

procedure backup;
  begin
    move(font, back, sizeof(font));
  end;
procedure undo;
  begin
    move(font, temp, sizeof(font));
    move(back, font, sizeof(font));
    move(temp, back, sizeof(font));
  end;

procedure beep;
  begin
    sound(500);
    delay(10);
    nosound;
  end;

procedure action_f2;
  begin
    restorecrtmode;
    save;
    setgraphmode(gm);
    draw_all;
  end;

procedure action_f3;
  begin
    restorecrtmode;
    save;
    load(true);
    setgraphmode(gm);
    draw_all;
  end;

procedure import;
  var
    s : string;
    f : file;
    i, a,b : integer;
  begin
    if block_s > block_e then exit;
    writeln('IMPORT CHARACTERS #',block_s,'..#',block_e,' FROM FILE');
    writeln('importing font must be the same size (',font_x,'x',font_y,')');
    write('import from file: '); readln(s);
    if s = '' then exit;
    write('startup character: '); readln(a);
    if (a < 0) or (a > 255) then
    begin
      writeln('- invalid number');
      readkey;
      exit;
    end;
    assign(f, s);
    filemode := 0;
    reset(f,1);
    filemode := 2;
    if ioresult <> 0 then
    begin
      writeln('- file not found');
      readkey;
      exit;
    end;
    if filesize(f) <> 256*font_y then
    begin
      close(f);
      writeln('- file size mismatch');
      readkey;
      exit;
    end;

    backup;
    for i := block_s to block_e do
    begin
      seek(f, ((i-block_s+a) mod 256) * font_y);
      blockread(f, font[i], font_y);
    end;
    close(f);

    writeln('- done');
    readkey;
  end;

procedure export;
  var
    s : string;
    i : integer;
    f : file;
  begin
    if block_s > block_e then exit;
    writeln('EXPORT CHARACTERS #',block_s,'..#',block_e,' TO FILE');
    write('export to file: '); readln(s);
    if s = '' then exit;
    assign(f, s);
    rewrite(f,1);
    for i := block_s to block_e do
      blockwrite(f, font[i], font_y);
    close(f);
    writeln('- done');
    readkey;
  end;

procedure action_import;
  begin
    restorecrtmode;
    import;
    setgraphmode(gm);
    draw_all;
  end;

procedure action_export;
  begin
    restorecrtmode;
    export;
    setgraphmode(gm);
    draw_all;
  end;

procedure action_backspace;
  begin
    undo;
    draw_editing_char;
    draw_char_table(0,255);
  end;

procedure action_blockstart;
  begin
    block_s := edit_n;
    draw_char_table(0,255);
  end;

procedure action_blockend;
  begin
    block_e := edit_n;
    draw_char_table(0,255);
  end;

procedure action_selectall;
  begin
    if (block_s = 0) and (block_e = 255) then begin
      block_s := 255;
      block_e := 0;
    end else begin
      block_s := 0;
      block_e := 255;
    end;
    draw_char_table(0,255);
  end;

procedure action_invertcyclemode;
  begin
    cycle := not cycle;
    draw_status;
  end;

procedure action_f5;
  begin
    automove_mode := not automove_mode;
    draw_status;
  end;

var
  i,j, s,e : integer;

procedure action_moveleft;
  begin
    backup;
    move(font, temp, sizeof(font));
    for i := s to e do
    begin
      for j := 0 to font_y-1 do
      begin
        font[i][j] := temp[i][j] shl 1;
        if cycle then
          inc(font[i][j], temp[i][j] shr 7);
      end;
    end;
    draw_char_table(s,e);
    draw_editing_char;
  end;

procedure action_moveright;
  begin
    backup;
    move(font, temp, sizeof(font));
    for i := s to e do
    begin
      for j := 0 to font_y-1 do
      begin
        font[i][j] := temp[i][j] shr 1;
        if cycle then
          inc(font[i][j], temp[i][j] shl 7);
      end;
    end;
    draw_char_table(s,e);
    draw_editing_char;
  end;

procedure action_moveup;
  begin
    backup;
    move(font, temp, sizeof(font));
    for i := s to e do
    begin
      for j := 0 to font_y-1-1 do
        font[i][j] := temp[i][j+1];
      if cycle then
        font[i][font_y-1] := temp[i][0]
      else
        font[i][font_y-1] := 0;
    end;
    draw_char_table(s,e);
    draw_editing_char;
  end;

procedure action_movedown;
  begin
    backup;
    move(font, temp, sizeof(font));
    for i := s to e do
    begin
      for j := font_y-1 downto 1 do
        font[i][j] := temp[i][j-1];
      if cycle then
        font[i][0] := temp[i][font_y-1]
      else
        font[i][0] := 0;
    end;
    draw_char_table(s,e);
    draw_editing_char;
  end;

procedure action_inverse;
  begin
    backup;
    move(font, temp, sizeof(font));
    for i := s to e do
      for j := 0 to font_y-1 do
        font[i][j] := not temp[i][j];
    draw_char_table(s,e);
    draw_editing_char;
  end;

procedure action_zero;
  begin
    backup;
    for i := s to e do
      for j := 0 to font_y-1 do
        font[i][j] := 0;
    draw_char_table(s,e);
    draw_editing_char;
  end;

procedure action_copy;
  begin
    backup;
    move(font, temp, sizeof(font));
    for i := s to e do
      move(temp[i], font[edit_n+i-s], max_font_size);
    draw_char_table(0,255);
    draw_editing_char;
  end;

procedure action_r1;
  begin
    edit_n := (edit_n +      1) and 255;
    draw_editing_char;
  end;
procedure action_l1;
  begin
    edit_n := (edit_n + 256- 1) and 255;
    draw_editing_char;
  end;
procedure action_d1;
  begin
    edit_n := (edit_n +     16) and 255;
    draw_editing_char;
  end;
procedure action_u1;
  begin
    edit_n := (edit_n + 256-16) and 255;
    draw_editing_char;
  end;

procedure action_r2;
  begin
    automove_dir := right;
    edit_x := (edit_x +        1) mod font_x;
  end;
procedure action_l2;
  begin
    automove_dir := left;
    edit_x := (edit_x + font_x-1) mod font_x;
  end;
procedure action_d2;
  begin
    automove_dir := down;
    edit_y := (edit_y +        1) mod font_y;
  end;
procedure action_u2;
  begin
    automove_dir := up;
    edit_y := (edit_y + font_y-1) mod font_y;
  end;

procedure action_togglepixel;
  begin
    backup;
    i := edit_x;
    if i = 8 then
      if edit_n in [$C0..$DF] then
        i := 7
      else begin
        i := -1;
        beep;
      end;
    if i <> -1 then
    begin
      font[edit_n][edit_y] :=
      font[edit_n][edit_y] xor (1 shl (7-i));
      draw_editing_char;
      draw_char_table(edit_n,edit_n);
    end;

    if automove_mode then
    case automove_dir of
      left:  action_l2;
      right: action_r2;
      up:    action_u2;
      down:  action_d2;
    end;

  end;

procedure action_switchwindow;
  begin
    window := window xor 1 xor 2;
    draw_window_border;
  end;

procedure edit;
  begin
    registerbgidriver(@egavgadriverproc);
    initgraph(gd,gm,'');

    init_vars;

    block_s := 255;
    block_e := 0;

    edit_n := 256 div 2 - 16 div 2;
    edit_x := font_x div 2;
    edit_y := font_y div 2;

    window := 1;
    cycle := true;
    automove_mode := false;

    draw_all;

    repeat

      draw_border(edit_n, 1);

      while not keypressed do
      begin
      end;

      draw_border(edit_n, 0);

      if block_e > block_s then begin
        s := block_s;
        e := block_e;
      end else begin
        s := edit_n;
        e := edit_n;
      end;

      case upcase(readkey) of
        #27: break;

        #09: action_switchwindow;

        '6': if window = 1 then action_r1 else action_r2;
        '4': if window = 1 then action_l1 else action_l2;
        '2': if window = 1 then action_d1 else action_d2;
        '8': if window = 1 then action_u1 else action_u2;

        'M': action_import;
        'P': action_export;

        'X': action_invertcyclemode;

        'S': action_blockstart;
        'E': action_blockend;
        'A': action_selectall;

        'L': action_moveleft;
        'R': action_moveright;
        'U': action_moveup;
        'D': action_movedown;

        'I': action_inverse;
        'Z': action_zero;

        'C': action_copy;

        #32: action_togglepixel;

        #08: action_backspace;

        #00: case readkey of
               #$3C: action_f2;
               #$3D: action_f3;
               #$3F: action_f5;
               'M': if window = 1 then action_r2 else action_r1;
               'K': if window = 1 then action_l2 else action_l1;
               'P': if window = 1 then action_d2 else action_d1;
               'H': if window = 1 then action_u2 else action_u1;
             end;
      end;

    until false;

    closegraph;

  end;

begin
  if paramcount <> 1 then halt;
  filename := paramstr(1);
  font_x := 9;

  load(false);
  edit;
  save;
end.
