
L_USEPATH               equ     1       ; 1=path allowed in filename
L_SCANPATH              equ     1       ; 1=test subdirs' names from path too
L_USEUPCASE             equ     1       ; 1=convert fname to upcase (not list)
L_NAMELENGTH            equ     8
L_EXTLENGTH             equ     3
L_FULLLENGTH            equ     (L_NAMELENGTH+L_EXTLENGTH)   ; max 255
L_STACKSIZE             equ     ((L_FULLLENGTH+3) and (not 3))
L_SPACEFILLER           equ     20h
L_ANYCHAR               equ     '?'     ; in list

; subroutine: is_in_list
; action:     check if file present in filemask list
; input:      ESI=list of following format:
;                list db NAMELENGTH+EXTLENGTH dup (?)
;                     ...               ; '?'=any char,20h=no char
;                     db 0              ; 0=end of list
;             EDX=file name
; output:     ZF (1=found(JE), 0=not found)

is_in_list:             pusha
                        sub     esp, L_STACKSIZE
; convert filename (USEPATH==path allowed)
                        cld
__restart:              mov     edi, esp
                        mov     ecx, L_NAMELENGTH
                        mov     al, L_SPACEFILLER
                        pusha
                        rep     stosb
                        popa
__getnextchar:          mov     al, [edx]
                        inc     edx
                        or      al, al
                        jz      __converted
        IF L_USEPATH EQ 1
                        cmp     al, ':'
                        je      __restart
                        cmp     al, '\'
        IF L_SCANPATH EQ 1
                        je      __converted
        ELSE
                        je      __restart
        ENDIF
        ENDIF
                        cmp     al, '.'
                        jne     __normalchar
                        lea     edi, [esp+L_NAMELENGTH]
                        mov     ecx, L_EXTLENGTH
                        mov     al, L_SPACEFILLER
                        pusha
                        rep     stosb
                        popa
                        jmp     __getnextchar
__normalchar:
        IF L_USEUPCASE EQ 1
                        cmp     al, 'a'
                        jb      __putchar
                        cmp     al, 'z'
                        ja      __putchar
                        sub     al, 32
__putchar:
        ENDIF
                        jecxz   __getnextchar
                        stosb
                        dec     ecx
                        jmp     __getnextchar
__converted:
; compare converted name with list entries
                        mov     ebp, esi
__cmpcycle:             mov     edi, esp
                        mov     ebx, ebp
                        mov     ecx, L_FULLLENGTH
                        cmp     [ebx], ch
                        je      __cmpdone
__cmpchar:              mov     al, [ebx]
                        mov     ah, [edi]
                        inc     ebx
                        inc     edi
                        cmp     al, L_ANYCHAR
                        je      __cmpcharok
                        cmp     al, ah
__cmpcharok:            loopz   __cmpchar
                        jne     __cmpcyclecont
                        add     esp, L_STACKSIZE
                        xor     eax, eax        ; ZR
                        popa
                        ret
__cmpcyclecont:         add     ebp, L_FULLLENGTH
                        jmp     __cmpcycle
__cmpdone:
        IF L_USEPATH EQ 1
        IF L_SCANPATH EQ 1
                        cmp     [edx-1], ch
                        jne     __restart
        ENDIF
        ENDIF
                        add     esp, L_STACKSIZE; NZ
                        popa
                        ret
