
////////x///////x///////x///////x///////x///////x///////x///////x///////x////

//#define LOGGING

#ifdef RELEASE
#undef LOGGING
#endif

////////x///////x///////x///////x///////x///////x///////x///////x///////x////

#ifdef LOGGING

#define LOG_TO_FILE             "_log"
#define LOG_TO_CONSOLE
#define LOG_TO_DEBUGGER
#define LOG_USE_CS

#define log1(x)         log(x)
#define log2(x,y)       log(x,y)
#define log3(x,y,z)     log(x,y,z)

#else // no LOGGING

#define log1(x)
#define log2(x,y)
#define log3(x,y,z)

#endif // LOGGING

////////x///////x///////x///////x///////x///////x///////x///////x///////x////

#ifdef LOGGING

#ifdef LOG_USE_CS
CRITICAL_SECTION critical_section_log;
#endif

void log(char* fmt, ...)
{
#ifdef LOG_USE_CS
  EnterCriticalSection(&critical_section_log);
#endif

  va_list va;
  va_start(va, fmt);
  char s[512];
  vsnprintf(s, sizeof(s)-1, fmt, va);
  va_end(va);

#ifdef LOG_TO_FILE
  char fn[512];
  GetModuleFileName(NULL,fn,sizeof(fn)-1);
  if (strrchr(fn,'\\'))
    *(strrchr(fn,'\\')+1) = 0;
  else
    fn[0]=0;
  strcat(fn, LOG_TO_FILE);

  FILE*f=fopen(fn,"a+");
  if (f==NULL)
  {
    snprintf(s, sizeof(s)-1, "ERROR:CAN NOT WRITE TO LOG FILE %s\n", fn);
  }
  else
  {
    fprintf(f, "%s", s);
    fclose(f);
  }
#endif // LOG_TO_FILE

#ifdef LOG_TO_CONSOLE
  printf("%s", s);
#endif // LOG_TO_CONSOLE

#ifdef LOG_TO_DEBUGGER
  OutputDebugString(s);
#endif // LOG_TO_DEBUGGER

#ifdef LOG_USE_CS
  LeaveCriticalSection(&critical_section_log);
#endif
} // log()

#endif // LOGGING

////////x///////x///////x///////x///////x///////x///////x///////x///////x////
