
MAXKEY                  equ     256
SIGNSIZE                equ     128

include                 consts.inc

callW                   macro   _xxx
                        extrn   _xxx:proc
                        call    _xxx
                        endm

                        p386
                        model   flat
                        locals  __
                        jumps

                        .data

seckey                  db      'KEY\SIGN\secret.rsa',0
pubkey                  db      'KEY\SIGN\public.rsa',0

                        align   4

k0_start:

keylen                  dd      ?
keyhash                 dd      ?
rsa_n                   db      MAXKEY/8 dup (?)
rsa_e                   db      MAXKEY/8 dup (?)

hashdata                db      MAXKEY/8 dup (?)

rsa_x                   db      MAXKEY/8 dup (?)
rsa_y                   db      MAXKEY/8 dup (?)
rsa_z                   db      MAXKEY/8 dup (?)

argc                    dd      ?
argv0                   db      256 dup (?)
argv1                   db      256 dup (?)
argv2                   db      256 dup (?)
argv3                   db      256 dup (?)

rsa_e_len               dd      ?
csum                    dd      ?
in_size                 dd      ?

k0_size                 equ     $-k0_start

                        .code
start:
                        call    zerodata
                        
                        call    dump_msg
                        db      'RSA SIGN -- (x) 2000 -- special '
                        if      SIGNSIZE ge 1000
                        db      SIGNSIZE/1000 mod 10+'0'
                        endif
                        db      SIGNSIZE/ 100 mod 10+'0'
                        db      SIGNSIZE/  10 mod 10+'0'
                        db      SIGNSIZE/   1 mod 10+'0'
                        db      '-bit edition',13,10,0

                        call    getcmdline

                        cmp     argc, 4
                        jne     help

                        mov     eax, argv1.dword ptr 0

                        cmp     al, '-'
                        je      switch
                        cmp     al, '/'
                        jne     noswitch

switch:                 mov     eax, argv1.dword ptr 1
noswitch:
                        or      ah, ah
                        jnz     help
                        or      al, 20h

                        cmp     al, 's'
                        je      call_sign
                        cmp     al, 'v'
                        je      call_verify

                        jmp     help

quit:
                        call    zerodata

                        push    -1
                        callW   ExitProcess

zerodata:               lea     edi, k0_start
                        mov     ecx, k0_size
                        xor     eax, eax
                        cld
                        rep     stosb
                        retn

call_sign:              lea     edx, seckey
                        call    readkey
                        call    sign
                        jmp     quit

call_verify:            lea     edx, pubkey
                        call    readkey
                        call    verify
                        jmp     quit

help:                   call    dump_msg
                        db      13,10
                        db      'syntax:',13,10
                        db      '  SIGN <command> datafile signfile',13,10
                        db      13,10
                        db      'commands:',13,10
                        db      '  s   -- sign datafile with KEY\SIGN\secret.rsa, write signature to signfile',13,10
                        db      '  v   -- verify datafile signature (compare to signfile)',13,10
                        db      0
                        jmp     quit

error:                  call    dump_msg
                        db      '***ERROR***',13,10,0
                        jmp     quit

readkey:
                        call    dump_msg
                        db      ' using ',0
                        call    dump_asciiz_edx
                        call    dump_crlf

                        call    fopen_ro
                        jc      error
                        xchg    ebx, eax

                        lea     edx, keyhash
                        mov     ecx, 4
                        call    fread

                        lea     edx, keylen
                        mov     ecx, 4
                        call    fread

                        cmp     keylen, SIGNSIZE
                        jne     error

                        push    eax
                        mov     edx, esp
                        mov     ecx, 4
                        call    fread
                        pop     ecx
                        lea     edx, rsa_n
                        call    fread

                        push    eax
                        mov     edx, esp
                        mov     ecx, 4
                        call    fread
                        pop     ecx
                        lea     edx, rsa_e
                        call    fread

                        call    fclose

                        retn

call_rsa:               push    MAXKEY
                        push    offset hashdata
                        push    offset rsa_x
                        push    offset rsa_e
                        push    offset rsa_n
                        call    rsa_main
                        retn

sign:                   call    calc_file_hash

                        call    call_rsa

;                       call    dump_msg
;                       db      ' writing ',0
;                       lea     edx, argv3
;                       call    dump_asciiz_edx
;                       call    dump_crlf

                        lea     edx, argv3
                        call    fcreate
                        jc      error
                        xchg    ebx, eax

                        lea     edx, rsa_x
                        mov     ecx, SIGNSIZE/8
                        call    fwrite

                        call    fclose

                        call    dump_msg
                        db      ' signature created',13,10,0

                        retn

verify:
;                       call    dump_msg
;                       db      ' reading ',0
;                       lea     edx, argv3
;                       call    dump_asciiz_edx
;                       call    dump_crlf

                        lea     edx, argv3
                        call    fopen_ro
                        jc      error
                        xchg    ebx, eax

                        lea     edx, hashdata
                        mov     ecx, SIGNSIZE/8
                        call    fread
                        cmp     eax, ecx
                        jne     error

                        call    fclose

;                       push    128/8
;                       push    offset hashdata
;                       call    debug_dump

                        call    call_rsa

;                       push    128/8
;                       push    offset rsa_x
;                       call    debug_dump

                        call    calc_file_hash

;                       push    128/8
;                       push    offset hashdata
;                       call    debug_dump

                        lea     esi, rsa_x
                        lea     edi, hashdata
                        mov     ecx, size hashdata
                        rep     cmpsb
                        jne     __err

__ok:                   call    dump_msg
                        db      ' signature verified OK',13,10,0

                        retn

__err:                  call    dump_msg
                        db      ' *** VERIFCATION FALIED ***',13,10,0

                        retn

calc_file_hash:
;                       call    dump_msg
;                       db      ' reading ',0
;                       lea     edx, argv2
;                       call    dump_asciiz_edx
;                       call    dump_crlf

                        lea     edx, argv2
                        call    fopen_ro
                        jc      error
                        xchg    ebx, eax

                        call    fgetsize
                        xchg    edi, eax

                        push    edi
                        push    40h
                        callW   GlobalAlloc
                        xchg    esi, eax

                        mov     edx, esi
                        mov     ecx, edi
                        call    fread

                        call    fclose

;                       pusha
;                       call    dump_msg
;                       db      ' calculating hash',13,10,0
;                       popa

                        mov     ecx, edi; ecx=data size, esi=data
                        lea     edi, hashdata  ; edi=hash
                        call    hash127

                        push    esi
                        callW   GlobalFree

                        retn

include                 cmdline.inc
include                 fioexlow.inc
include                 console.inc

include                 rsalib1.inc

include                 ..\hash127.inc

;include                ddump.inc

                        end     start
