###############################################################################
# lst2xpl 1.00    .lst to .xpl convertor   (x) 2oo4   z0mbie.host.sk          #
###############################################################################

$SAME_LINE_LBL   = 0;            # keep label: on the same src lines
$START_POS       = 35;           # position of /*
$LABEL_POS       = $START_POS;   # used only if $SAME_LINE_LBL == 0
$START_CMT_POS   = 65;           # position of ; comment
$END_POS         = 76;           # position of */
$COPY_SUBSTR     = ";;;;";       # if found, output as C line
$USE_OFFS        = 1;            # add '+XXXX' offset
$STRIP_CMT       = 1;            # strip ; comments

if (scalar @ARGV != 1)
{
  print "syntax: lst2xpl.pl infile.lst\n";
  exit;
}

$lst = $ARGV[0];

open(F, "<$lst") || die "ERROR: cant read: $lst";
@lines = <F>;
close F;
chomp(@lines);

print "/* GENERATED BY lst2xpl.pl, DO NOT EDIT! */\n";

foreach $line (@lines)
{
  # match format?
  if ($line =~ /.+$COPY_SUBSTR(.*)/)
  {
    print $1 . "\n";
  }
  elsif ($line =~ /(\s[\s0-9]{6})\s0000([\s0-9A-F]{4})([\s0-9A-F:\|]*)\t+\s(.*)/)
  {
    #$line = $1;
    $offs  = $2;
    $bytes = $3;
    $src   = $4;
    @bytes = split(" ", $bytes);
    $code  = "";
    foreach $s (@bytes)
    {
      if ($s =~ /^([0-9A-F]{2})[:\|]?$/)
      {
        $code .= "\\x".$1;
      }
      elsif ($s =~ /^([0-9A-F]{2})([0-9A-F]{2})$/)
      {
        $code .= "\\x".$2."\\x".$1;
      }
      elsif ($s =~ /^([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})([0-9A-F]{2})$/)
      {
        $code .= "\\x".$4."\\x".$3."\\x".$2."\\x".$1;
      }
      else
      {
        die "ERROR: invalid term: $s\n";
      }
    }

    $src =~ tr/\t/ /;

    $cmt = "";
    if ($src =~ /^(.*)\s*;\s*(.*)/)
    {
      $src = $1;
      $cmt = $2;
    }

    $lbl  = "";
    if ($src =~ /^([a-zA-Z0-9\_\@\$\?]+):\s*(.*)/)
    {
      $lbl = $1;
      $src = $2;
    }

    $cmd  = $src;
    $arg1 = "";
    $arg2 = "";
    if ($src =~ /^(.+?)\s+(.+?)\s*,\s*(.+)\s*$/)
    {
      $cmd  = $1;
      $arg1 = $2;
      $arg2 = $3;
    }
    elsif ($src =~ /^(.+?)\s+(.+)$/)
    {
      $cmd  = $1;
      $arg1 = $2;
      $arg2 = "";
    }
    $cmd  =~ s/\s+$//;
    $arg1 =~ s/\s+$//;
    $arg2 =~ s/\s+$//;

    #print "[$lbl][$cmd][$arg1][$arg2][;$cmt]\n";

    if (($offs ne "") && (($code ne "") || ($lbl ne "") || ($cmt ne "")))
    {

      $out = $code eq "" ? "" : "\"$code\"";
      $out .= " " x ($START_POS-1 - length $out);
      $out .= "/* ";
      if ($USE_OFFS)
      {
        $out .= "+$offs  ";
      }
      if ($lbl ne "")
      {
        if (($SAME_LINE_LBL == 1) || ($cmd eq ""))
        {
          $out .= "$lbl: ";
        }
        else
        {
          $out = " " x ($LABEL_POS-1) . "/* ";
          if ($USE_OFFS)
          {
            $out .= "+$offs  ";
          }
          $out .= "$lbl: ";
          $out .= " " x ($END_POS-1 - length $out);
          $out .= " */\n";
          print $out;
          #
          $out = "\"$code\"";
          $out .= " " x ($START_POS-1 - length $out);
          $out .= "/* ";
          if ($USE_OFFS)
          {
            $out .= "+$offs  ";
          }
        }
      }
      $out .= $cmd;
      if ($arg1 ne "")
      {
        $out .= " " x (7 - length $cmd);
        $out .= " $arg1";
      }
      if ($arg2 ne "")
      {
        $out .= ", $arg2";
      }
      if (($STRIP_CMT == 0) && ($cmt ne ""))
      {
        $out .= " " x ($START_CMT_POS-1 - length $out);
        $out .= "; " . $cmt;
      }
      $out .= " " x ($END_POS-1 - length $out);
      $out .= " */\n";
      print $out;

    }
  }
}

# EOF
