
// tcp-switch v2.00

// g++ switch2.cpp -o switch2.o -DLINUX
// cl switch2.cpp ws2_32.lib /DDEBUG /DWIN32 /MD /YX /link /SUBSYSTEM:WINDOWS
// bcc32 -DDEBUG -DWIN32 -tW switch2.cpp ws2_32.lib

#ifdef WIN32
#include <winsock2.h>
#include <windows.h>
#include <wincrypt.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <io.h>
#include <dos.h>
#include <direct.h>
#include <math.h>
#include <time.h>
#include <tlhelp32.h>
#endif // WIN32

#ifdef LINUX
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <sys/time.h>
#include <sys/resource.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <time.h>
#include <pthread.h>
#include <unistd.h>
#include <fcntl.h>
#include <resolv.h>
#include <netdb.h>
#include <netinet/in.h>
#include <memory.h>
#include <string.h>
#include <dirent.h>
#include <errno.h>
#include <arpa/inet.h>
#include <signal.h>
#endif // LINUX
#pragma hdrstop

#define BANNER         "tcp-switch v2.00"
//#define PROMPT         "#"

#ifdef WIN32
#define MSG_NOSIGNAL   0
#define socklen_t      int
#define snprintf       _snprintf
#define vsnprintf      _vsnprintf
#endif
#ifdef LINUX
#define SOCKET         int
#define WINAPI
#define PASCAL
#define closesocket    close
typedef unsigned char  BYTE;
typedef unsigned long  DWORD;
#endif

#define MAXOBJECTS              1024

#define STATUS_UNUSED           1
#define STATUS_LISTEN_DATA      2
#define STATUS_LISTEN_CTL       3
#define STATUS_WAITCONN_DATA    4
#define STATUS_DATA             5
#define STATUS_CTL              6

#define LINK_NONE               -1      // used for par[i]

// link type:
#define LT_NONE                 0
#define LT_SINGLE_KEEP          1
#define LT_SINGLE_DROP          2
#define LT_MULTI_KEEP           3
#define LT_MULTI_DROP           4
#define LT_MAX                  5
#define LT_ANY                  -1

int     status[MAXOBJECTS];
SOCKET  sock  [MAXOBJECTS];
int     par   [MAXOBJECTS];
char    lnk   [MAXOBJECTS][MAXOBJECTS];
struct sockaddr_in caddr[MAXOBJECTS];

void ctl_send(int srcctl, int dstctl, char* fmt, ...);

int find_unused_id(int pctl)
{
  for(int i=0; i<MAXOBJECTS; i++)
    if (status[i] == STATUS_UNUSED)
    {
      ctl_send(pctl, -1, "alloc:id=%d", i);
      return i;
    }
  ctl_send(pctl, -1, "error:no more objects");
  return -1;
} // find_unused_id

int get_lnk_count(int i, int lt/*LT_xxx*/)
{
  int c = 0;
  for(int j=0; j<MAXOBJECTS; j++)
    if ( (lt == lnk[i][j]) ||
       (lt == LT_ANY && lnk[i][j] != LT_NONE) )
      c++;
  return c;
} // get_lnk_count

void my_close_socket(int pctl, int i);

void my_close_by_lt(int pctl, int lt, int i)
{
  switch(lt)
  {
    case LT_SINGLE_KEEP: break;
    case LT_MULTI_KEEP:  break;
    case LT_SINGLE_DROP: my_close_socket(pctl, i);
                         break;
    case LT_MULTI_DROP:  if (get_lnk_count(i,LT_ANY) == 0)
                           my_close_socket(pctl, i);
                         break;
  }//switch
} // my_close_by_lt

void my_close_socket(int pctl, int i)
{
  for(int j=0; j<MAXOBJECTS; j++)
  {
    if (lnk[j][i] != LT_NONE)
    {
      int lt = lnk[j][i];
      lnk[j][i] = LT_NONE;
      ctl_send(pctl, -1, "lnk[%d,%d]=0", j,i);
      my_close_by_lt(pctl, lt, j);
    }
    if (lnk[i][j] != LT_NONE)
    {
      int lt = lnk[i][j];
      lnk[i][j] = LT_NONE;
      ctl_send(pctl, -1, "lnk[%d,%d]=0", i,j);
      my_close_by_lt(pctl, lt, j);
    }
    if (par[j] == i)
    {
      par[j] = LINK_NONE;
    }
  }
  status[i] = STATUS_UNUSED;
  if (sock[i])
    closesocket(sock[i]);
  sock[i] = 0;
  par[i] = LINK_NONE;
  memset(&caddr[i],0,sizeof(struct sockaddr_in));
  ctl_send(pctl, -1, "close:id=%d", i);
} // my_close_socket

int my_connect_socket(int pctl, int i, unsigned long ip, unsigned short port)
{
  if (status[i] != STATUS_UNUSED)
    return 0;

  sock[i] = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
  if ((sock[i] == 0) || (sock[i] == -1))
  {
    sock[i] = 0;
    return 0;
  }

  struct sockaddr_in addr;
  addr.sin_family      = AF_INET;
  addr.sin_port        = htons(port);
  addr.sin_addr.s_addr = ip;

  int res = connect(sock[i], (struct sockaddr*)&addr, sizeof(addr));
  if (res != 0)
  {
    closesocket(sock[i]);
    sock[i] = 0;
    ctl_send(pctl, -1, "error:connect,%s:%d", inet_ntoa(*(struct in_addr*)&ip), port);
    return 0;
  }

  status[i] = STATUS_DATA;
  memset(&lnk[i], LT_NONE, MAXOBJECTS);

  ctl_send(pctl, -1, "connect:id=%d,%s:%d", i, inet_ntoa(*(struct in_addr*)&ip), port);
  return 1;
} // my_connect_socket

int my_listen_socket(int pctl, int i, int l_type, unsigned short port)
{
  if (status[i] != STATUS_UNUSED)
    return 0;

  sock[i] = socket(AF_INET, SOCK_STREAM, IPPROTO_IP);
  if ((sock[i] == 0) || (sock[i] == -1))
  {
    sock[i] = 0;
    ctl_send(pctl,-1, "error:socket,port=%d", port);
    return 0;
  }

  struct sockaddr_in addr;
  addr.sin_family      = AF_INET;
  addr.sin_port        = htons(port);
  addr.sin_addr.s_addr = 0;

  if (bind(sock[i], (struct sockaddr*)&addr, sizeof(struct sockaddr)) != 0)
  {
    ctl_send(pctl,-1, "error:bind,port=%d", port);
    return 0;
  }

  if (listen(sock[i], SOMAXCONN) != 0)
  {
    ctl_send(pctl,-1, "error:listen,port=%d", port);
    return 0;
  }

  status[i] = l_type;
  memset(&lnk[i], LT_NONE, MAXOBJECTS);

  ctl_send(pctl,-1, "listen:id=%d,port=%d", i, port);

  return 1;
} // my_listen_socket

void ctl_send(int srcctl, int dstctl, char* fmt, ...)
{
  static char s[8192];
  static char q[8192];

  va_list va;
  va_start(va, fmt);
  vsnprintf(s, sizeof(s)-1, fmt, va);
  va_end(va);

  for(int i=0; i<MAXOBJECTS; i++)
  if (dstctl == -1 || dstctl == i)
  if (status[i] == STATUS_CTL)
  if (sock[i])
  {
    if (srcctl == i)
      sprintf(q,"%s\r\n",s);
    else
      if (srcctl == -1)
        sprintf(q,"(%s)",s);
      else
        sprintf(q,"(ctl=%d:%s)", srcctl, s);
    if (send(sock[i], q, strlen(q), MSG_NOSIGNAL) != (int)strlen(q))
    {
      my_close_socket(srcctl, i);
      ctl_send(srcctl, -1, "error:send,ctl_id=%d", i);
    }
  }

} // ctl_send

#define MAXTOKEN        32
#define MAXLINE         1024
char token[MAXTOKEN][MAXLINE];
int  token_n = 0;

char* get_token(char* text)
{

  if ((text == NULL) || (*text == 0))
    return NULL;

  token_n = (token_n + 1) % MAXTOKEN;

#define IS_SPACE(x)  (((x)==32)||((x)==9)||((x)==13)||((x)==10))

  while(IS_SPACE(*text)) text++;

  char* z = 0;
  for(char* x=text; *x; x++)
  if (IS_SPACE(*x))
  {
    z = x;
    break;
  }

  int q=0;

  if (text[0]=='"')
  {
    z = text+1;
    while((*z!=0)&&(*z!='"')) z++;
    z++;
    q=1;
  }
  else
  if (text[0]=='\x27')
  {
    z = text+1;
    while((*z!=0)&&(*z!='\x27')) z++;
    z++;
    q=1;
  }

  if (z)
  {
    strncpy(token[token_n], text, z-text);
    token[token_n][z-text] = 0;
    strcpy(text, z+1);
    if (q) { strcpy(token[token_n],token[token_n]+1); token[token_n][strlen(token[token_n])-1]=0; };
    return token[token_n];
  }
  else
  {
    strcpy(token[token_n], text);
    text[0] = 0;
    if (q) { strcpy(token[token_n],token[token_n]+1); token[token_n][strlen(token[token_n])-1]=0; };
    if (token[token_n][0] == 0)
      return NULL;
    else
      return token[token_n];
  }

  return NULL;
} // get_token

int find_id(char* str)
{
  int id = atoi(str);
  if (id != 0 || (!strcmp(str,"0"))) return id;
  if (((str[0]|32)=='l')||((str[0]|32)=='r'))
  {
    for(int i=0; i<MAXOBJECTS; i++)
      if (status[i] != STATUS_UNUSED)
      {
        struct sockaddr_in addr;
        socklen_t addrlen = sizeof(addr);
        int res;
        if ((str[0]|32)=='l')
          res = getsockname(sock[i], (struct sockaddr*)&addr, &addrlen);
        else
          if (status[i]==STATUS_WAITCONN_DATA)
          {
            memcpy(&addr, &caddr[i], sizeof(addr));
            res = 0;
          }
          else
            res = getpeername(sock[i], (struct sockaddr*)&addr, &addrlen);
        if (!res)
           if (ntohs(addr.sin_port) == atoi(str+1))
             return i;
      }
  }

  return -1;
} // find_id

int control(int i, char* data, int size)
{
  data[size] = 0;
  char *a1, *a2, *a3, *a4;

  while(char* text = get_token(data))
  {

    if (!strcmp(text,"help"))
    {
      ctl_send(i, i, "!commands:" );
      ctl_send(i, i, "!  help, show, showlinks, exit, die" );
      ctl_send(i, i, "!  listen|listenctl port" );
      ctl_send(i, i, "!  conn|initconn ip port" );
      ctl_send(i, i, "!  kill id" );
      ctl_send(i, i, "!  link dstid srcid type" );
      ctl_send(i, i, "!  xlink dstid1 dstid2 type" );
      ctl_send(i, i, "!  [un]mitm m_id1 m_id2 id1 id2" );
      ctl_send(i, i, "!  inject dstid prefix snippet.bin [text]" );
      ctl_send(i, i, "!  id := 0..%d | L0..65535 | R0..65535", MAXOBJECTS-1 );
      ctl_send(i, i, "!  link type: 0=none, %d=single,keep %d=single,drop %d=multi,keep %d=multi,drop",
        LT_SINGLE_KEEP,
        LT_SINGLE_DROP,
        LT_MULTI_KEEP ,
        LT_MULTI_DROP  );
    }
    else
    if (!strcmp(text,"showlinks"))
    {
      static char s4[6*MAXOBJECTS];
      int n;

      strcpy(s4,"!  id          ");
      for(n=0; n<MAXOBJECTS; n++)
      if (status[n] != STATUS_UNUSED)
        sprintf(s4+strlen(s4),"%-6d ", n);

      ctl_send(i,i,s4);

      strcpy(s4,"!       status ");
      for(n=0; n<MAXOBJECTS; n++)
      if (status[n] != STATUS_UNUSED)
        sprintf(s4+strlen(s4),"%-6s ",
          status[n]==STATUS_LISTEN_DATA  ?"ld":
          status[n]==STATUS_LISTEN_CTL   ?"lc":
          status[n]==STATUS_WAITCONN_DATA?"wc":
          status[n]==STATUS_DATA         ?"d":
          status[n]==STATUS_CTL          ?"c":"???" );

      ctl_send(i,i,s4);

      for(n=0; n<MAXOBJECTS; n++)
      if (status[n] != STATUS_UNUSED)
      {
        strcpy(s4,"!");

        sprintf(s4+strlen(s4),"%-6d ",n);
        sprintf(s4+strlen(s4),"%-6s ",
          status[n]==STATUS_LISTEN_DATA  ?"ld":
          status[n]==STATUS_LISTEN_CTL   ?"lc":
          status[n]==STATUS_WAITCONN_DATA?"wc":
          status[n]==STATUS_DATA         ?"d":
          status[n]==STATUS_CTL          ?"c":"???" );

        for(int j=0; j<MAXOBJECTS; j++)
        if (status[j] != STATUS_UNUSED)
        {
          if (lnk[n][j])
            sprintf(s4+strlen(s4),"%-6d ",lnk[n][j]);
          else
            strcat(s4,".      ");
        }

        ctl_send(i,i,s4);
      }

    }
    else
    if (!strcmp(text,"show"))
    {
      int id = -2;
      char* a1 = get_token(data);
      if (a1 != NULL)
        id = find_id(a1);
      for(int j=0; j<MAXOBJECTS; j++)
      if (status[j] != STATUS_UNUSED)
      if (id==-2||id==j)
      {
        static char s1[32], s2[32], s3[32], s4[6*MAXOBJECTS];
        struct sockaddr_in addr;
        socklen_t addrlen = sizeof(addr);
        if (sock[j]==0)
        {
          sprintf(s1,"N/A");
          if (status[j]==STATUS_WAITCONN_DATA)
            sprintf(s2,"%s:%d",inet_ntoa(caddr[j].sin_addr), ntohs(caddr[j].sin_port));
          else
            sprintf(s2,"N/A");
        }
        else
        {
          getsockname(sock[j], (struct sockaddr*)&addr, &addrlen);
          sprintf(s1, "%s:%d", inet_ntoa(addr.sin_addr), ntohs(addr.sin_port));
          if (getpeername(sock[j], (struct sockaddr*)&addr, &addrlen)!=0)
            strcpy(s2,"N/A");
          else
            sprintf(s2, "%s:%d", inet_ntoa(addr.sin_addr), ntohs(addr.sin_port));
        }
        if (par[j]==LINK_NONE) strcpy(s3,"N/A"); else sprintf(s3, "%d", par[j]);

        s4[0]=0;
        for(int l=1; l<LT_MAX; l++)
        {
          int q = strlen(s4);
          sprintf(s4+q, " %s: ", l==LT_SINGLE_KEEP?"t1=sk":
                                 l==LT_SINGLE_DROP?"t2=sd":
                                 l==LT_MULTI_KEEP ?"t3=mk":
                                 l==LT_MULTI_DROP ?"t4=md":"???");
          int n=0;
          for(int k=0; k<MAXOBJECTS; k++)
          {
            if (lnk[j][k]==l)
            {
              sprintf(s4+strlen(s4),"%s%d", n>0?",":"", k);
              n++;
            }
          }
          if (n==0) s4[q]=0;
        }
        if (!s4[0]) strcpy(s4,"N/A");

        ctl_send(i, i, "!id=%-6d%s status=%-20s local=%-16s remote=%-16s parent=%-6s link:%s",
                    j,
                    i==j?"*":" ",
                    status[j]==STATUS_LISTEN_DATA?"LISTEN_DATA":
                    status[j]==STATUS_LISTEN_CTL?"LISTEN_CTL":
                    status[j]==STATUS_DATA?"DATA":
                    status[j]==STATUS_CTL?"CTL":
                    status[j]==STATUS_WAITCONN_DATA?"WAITCONN_DATA":"???",
                    s1,
                    s2,
                    s3,
                    s4 );
      }
    }
    else
    if (!strcmp(text,"exit"))
    {
      ctl_send(i, i, "bye");
      my_close_socket(i, i);
      ctl_send(i, -1, "exit,id=%d", i);
      return 0;
    }
    else
    if (!strcmp(text,"die"))
    {
      ctl_send(i, -1, "die sent");
      for(int i=0; i<MAXOBJECTS; i++)
        if (sock[i] != 0)
          closesocket(sock[i]);
      exit(0);
      return 0;
    }
    else
    if ( (!strcmp(text,"kill")) &&
         ((a1 = get_token(data)) != NULL) )
    {
      int id = find_id(a1);
      if ((id >= 0) && (id < MAXOBJECTS) && (status[id] != STATUS_UNUSED))
      {
        ctl_send(i, -1, "kill,id=%d", id);
        my_close_socket(i, id);
        if (id == i)
          return 0;
      }
    }
    else
    if ( (!strcmp(text,"xlink")) &&
         ((a1 = get_token(data)) != NULL) &&
         ((a2 = get_token(data)) != NULL) &&
         ((a3 = get_token(data)) != NULL) )
    {
      int id1 = find_id(a1);
      int id2 = find_id(a2);
      int v   = atoi(a3);
      if (v < LT_MAX)
      if (((id1 >= 0) && (id1 < MAXOBJECTS)) && (status[id1] != STATUS_UNUSED))
      if (((id2 >= 0) && (id2 < MAXOBJECTS)) && (status[id2] != STATUS_UNUSED))
      {
        // one more check?
        ctl_send(i, -1, "lnk[%d,%d]=lnk[%d,%d]=%d", id1, id2, id2, id1, v);
        lnk[id1][id2] = v;
        lnk[id2][id1] = v;
      }
    }
    else
    if ( (!strcmp(text,"link")) &&
         ((a1 = get_token(data)) != NULL) &&
         ((a2 = get_token(data)) != NULL) &&
         ((a3 = get_token(data)) != NULL) )
    {
      int id1 = find_id(a1);
      int id2 = find_id(a2);
      int v   = atoi(a3);
      if (v < LT_MAX)
      if (((id1 >= 0) && (id1 < MAXOBJECTS)) && (status[id1] != STATUS_UNUSED))
      if (((id2 >= 0) && (id2 < MAXOBJECTS)) && (status[id2] != STATUS_UNUSED))
      {
        ctl_send(i, -1, "lnk[%d,%d]=%d", id1, id2, v);
        lnk[id1][id2] = v;
      }
      //return 1;
    }
    else
    if ( ((!strcmp(text,"mitm")) || (!strcmp(text,"unmitm"))) &&
         ((a1 = get_token(data)) != NULL) &&
         ((a2 = get_token(data)) != NULL) &&
         ((a3 = get_token(data)) != NULL) &&
         ((a4 = get_token(data)) != NULL) )
    {
      int m_id1 = find_id(a1);
      int m_id2 = find_id(a2);
      int id1   = find_id(a3);
      int id2   = find_id(a4);
      if (((m_id1 >= 0) && (m_id1 < MAXOBJECTS)) && (status[m_id1] != STATUS_UNUSED))
      if (((m_id2 >= 0) && (m_id2 < MAXOBJECTS)) && (status[m_id2] != STATUS_UNUSED))
      if (((id1 >= 0) && (id1 < MAXOBJECTS)) && (status[id1] != STATUS_UNUSED))
      if (((id2 >= 0) && (id2 < MAXOBJECTS)) && (status[id2] != STATUS_UNUSED))
      {
        ctl_send(i, -1, "%s,m_id1=%d,m_id2=%d,id1=%d,id2=%d", text, m_id1, m_id2, id1, id2);
        int v = (!strcmp(text,"mitm")) ? 1 : 0;

        // id1 <==> id2
        lnk[id1][id2] = 1-v;
        lnk[id2][id1] = 1-v;

        // id1 --> m_id1 --> id2
        // id1 <-- m_id2 <-- id2
        lnk[id1][m_id1] = v;
        lnk[m_id1][id2] = v;

        lnk[id2][m_id2] = v;
        lnk[m_id2][id1] = v;
      }
      //return 1;
    }
    else
    if ( (!strcmp(text,"listen")) &&
         ((a1 = get_token(data)) != NULL) )
    {
      int port = atoi(a1);
      int j = find_unused_id(i);
      if (j != -1)
      {
        par[j] = i;
        if (!my_listen_socket(i, j, STATUS_LISTEN_DATA, port))
          my_close_socket(i, j);
      }
    }
    else
    if ( (!strcmp(text,"listenctl")) &&
         ((a1 = get_token(data)) != NULL) )
    {
      int port = atoi(a1);
      int j = find_unused_id(i);
      if (j != -1)
      {
        par[j] = i;
        if (!my_listen_socket(i, j, STATUS_LISTEN_CTL, port))
          my_close_socket(i, j);
      }
    }
    else
    if ( (!strcmp(text,"initconn")) &&
         ((a1 = get_token(data)) != NULL) &&
         ((a2 = get_token(data)) != NULL) )
    {
      unsigned long ip   = inet_addr(a1);
      int port           = atoi(a2);
      int j = find_unused_id(i);
      if (j != -1)
      {
        par[j] = i;

        status[j] = STATUS_WAITCONN_DATA;
        sock[j]   = 0;
        memset(&lnk[j], LT_NONE, MAXOBJECTS);
        caddr[j].sin_family = AF_INET;
        caddr[j].sin_port = htons(port);
        caddr[j].sin_addr.s_addr = ip;

        ctl_send(i, -1, "waitconn:id=%d,%s:%d",
                         j, inet_ntoa(*(struct in_addr*)&ip), port);
      }
    }
    else
    if ( (!strcmp(text,"conn")) &&
         ((a1 = get_token(data)) != NULL) &&
         ((a2 = get_token(data)) != NULL) )
    {
      unsigned long ip   = inet_addr(a1);
      int port           = atoi(a2);
      int j = find_unused_id(i);
      if (j != -1)
      {
        if (my_connect_socket(i, j, ip, port))
          par[j] = i;
        else
          my_close_socket(i, j);
      }
    }
    else
    if ( (!strcmp(text,"inject")) &&
         ((a1 = get_token(data)) != NULL) &&
         ((a2 = get_token(data)) != NULL) &&
         ((a3 = get_token(data)) != NULL) )
    {
      char* t = get_token(data);

      int id1 = find_id(a1);
      char* pfx = a2;
      int pfx_len = strlen(pfx);
      if (((id1 >= 0) && (id1 < MAXOBJECTS)) && (status[id1] == STATUS_DATA))
      if (sock[id1] != 0)
      {
        // todo: must lock if multiple ctl sessions
        static char buf[65536];
        FILE*f=fopen(a3,"rb");
        if (!f)
          ctl_send(i,-1,"error:file not found:'%s'", a3);
        else
        {
          ctl_send(i, -1, "!injecting [%s]+[?]+[%s]+[%s] into id=%d", a2,a3,t==NULL?"<null>":t, id1);

          fseek(f,0,SEEK_END);
          int len = ftell(f);
          rewind(f);
          int len_a4 = (len+(t==NULL?0:(strlen(t)+1))+3)&(~3);
          int delta = len_a4 - (len+(t==NULL?0:(strlen(t)+1)));
          if (len_a4 <= sizeof(buf))
          {
            memcpy(buf, pfx, pfx_len);
            *(unsigned long*)&buf[pfx_len] = len_a4;
            int res = send(sock[id1], buf, pfx_len+4, MSG_NOSIGNAL);
            if ((res == 0) || (res == -1))
              my_close_socket(i, id1);
            else
            {
#ifdef WIN32
      Sleep(1000);
#endif
#ifdef LINUX
      usleep(1000*1000);
#endif
              //Sleep(1000); // should be enough for prev data block to be sent out

              fread(buf,1,len,f);
              if (t)
                memcpy(buf+len,t,strlen(t)+1);
              if (delta)
                memset(buf+len_a4-delta,0,delta);
              res = send(sock[id1], buf, len_a4, MSG_NOSIGNAL);
              if ((res == 0) || (res == -1))
                my_close_socket(i, id1);
              else
                if (t)
                  ctl_send(i, -1, "!injected [%s]+[%d]+%s+[%s] into id=%d",
                    a2,len_a4,a3,t,id1);
                else
                  ctl_send(i, -1, "!injected [%s]+[%d]+%s into id=%d",
                    a2,len_a4,a3,id1);
            }
          }
          fclose(f);
        }
      }
      //return 1;
    }
    else
    {
      ctl_send(i, -1, "error:syntax,\"%s\"", text);
    }

  } // for each token

  return 1;

} // control

#ifdef WIN32
int PASCAL WinMain(HINSTANCE, HINSTANCE, LPSTR, int)
#endif
#ifdef LINUX
int main()
#endif
{

#ifdef WIN32
  WSADATA WSAData;
  WSAStartup(MAKEWORD(1,1), &WSAData);
#endif

#ifdef LINUX
  printf("pid=%d\n", getpid()+1);
  if (daemon(/*nochdir==*/1,/*noclose==*/0) != 0)
    exit(0);
#endif

  int i,j,res;

  for(i=0; i<MAXOBJECTS; i++)
  {
    status[i] = STATUS_UNUSED;
    sock  [i] = 0;
    par   [i] = LINK_NONE;
    memset(&lnk[i], LT_NONE, MAXOBJECTS);
    memset(&caddr[i],0,sizeof(struct sockaddr_in));
  }

  FILE*f=fopen("switch2.ini","rb");
  if (f==NULL)
  {
    if (!my_listen_socket(-1, 0, STATUS_LISTEN_CTL, 666/*port*/))
      exit(0);
  }
  else
  {
    char s[1024];
    for(char*t=fgets(s,sizeof(s)-1,f); t!=NULL; t=fgets(s,sizeof(s)-1,f))
    {
      if (s[0] != 0 && s[0] != '#')
        control(-1,s,strlen(s));
    }
    fclose(f);
  }

  for(;;) // main cycle
  {

    int idle = 1;

    for(i=0; i<MAXOBJECTS; i++)
    {

      switch(status[i])
      {

        case STATUS_LISTEN_DATA:
        case STATUS_LISTEN_CTL:
             {

               fd_set readfds;
               FD_ZERO(&readfds);
               FD_SET(sock[i], &readfds);

               timeval to = {0,0};

               res = select(sock[i]+1, &readfds, NULL, NULL, &to);

               if (res == -1)
               {
                 idle = 0;

                 //printf("killed listen %d\n", i);

                 my_close_socket(-1, i);
                 break;
               } // res == -1

               if (res == 1)
               {
                 idle = 0;

                 j = find_unused_id(-1);
                 if (j != -1)
                 {
                   par[j] = i;
                   sock[j] = accept(sock[i], NULL, NULL);
                   if ((sock[j] != 0) && (sock[j] != -1))
                   {
                     ctl_send(-1, -1, "connected:id=%d,par=%d", j, i);

                     status[j] = status[i] == STATUS_LISTEN_DATA ? STATUS_DATA : STATUS_CTL;
                     memset(&lnk[j], LT_NONE, MAXOBJECTS);

                     if (status[i] == STATUS_LISTEN_DATA)
                     {

                       for(int p=0; p<MAXOBJECTS; p++)
                       if (status[p] == STATUS_WAITCONN_DATA)
                       {
                         int child_created = -1;

                         if (lnk[i][p] != LT_NONE)
                         {
                           int t = -1;
                           for(int k=0; k<MAXOBJECTS; k++)
                             if (par[k] == p)
                               if ( (lnk[i][p] == LT_MULTI_KEEP) ||
                                    (lnk[i][p] == LT_MULTI_DROP) ||
                                    (
                                      (
                                        (get_lnk_count(j,LT_ANY) == 0) ||
                                        (get_lnk_count(j,LT_ANY) == 1 && lnk[j][k] != LT_NONE)
                                      )
                                      &&
                                      (
                                        (get_lnk_count(k,LT_ANY) == 0) ||
                                        (get_lnk_count(k,LT_ANY) == 1 && lnk[k][j] != LT_NONE)
                                      )
                                    )
                                  )
                               {
                                 t = k;
                                 break;
                               }
                           // todo -- check mult
                           if (t == -1)
                           if ( (lnk[i][p] == LT_MULTI_KEEP) ||
                                (lnk[i][p] == LT_MULTI_DROP) ||
                                (get_lnk_count(j,LT_ANY) == 0)
                              )
                           {
                             t = find_unused_id(-1);
                             if (t != -1)
                             {
                               if (!my_connect_socket(-1, t, caddr[p].sin_addr.s_addr, ntohs(caddr[p].sin_port)))
                                 t = -1;
                               else
                               {
                                 par[t] = p;
                                 child_created = t;
                               }
                             }
                           }
                           if (t != -1)
                           {
                             lnk[j][t] = lnk[i][p];
                             ctl_send(-1, -1, "lnk[%d,%d]=%d", j,t,lnk[j][t]);
                           }
                         }

                         if (lnk[p][i] != LT_NONE)
                         {
                           int t = -1;
                           if (child_created != -1)
                             t = child_created;
                           else
                           for(int k=0; k<MAXOBJECTS; k++)
                             if (par[k] == p)
                               if ( (lnk[p][i] == LT_MULTI_KEEP) ||
                                    (lnk[p][i] == LT_MULTI_DROP) ||
                                    (
                                      (
                                        (get_lnk_count(j,LT_ANY) == 0) ||
                                        (get_lnk_count(j,LT_ANY) == 1 && lnk[j][k] != LT_NONE)
                                      )
                                      &&
                                      (
                                        (get_lnk_count(k,LT_ANY) == 0) ||
                                        (get_lnk_count(k,LT_ANY) == 1 && lnk[k][j] != LT_NONE)
                                      )
                                    )
                                  )
                               {
                                 t = k;
                                 break;
                               }
                           if (t == -1)
                           if ( (lnk[i][p] == LT_MULTI_KEEP) ||
                                (lnk[i][p] == LT_MULTI_DROP) ||
                                (get_lnk_count(j,LT_ANY) == 0)
                              )
                           {
                             t = find_unused_id(-1);
                             if (t != -1)
                             {
                               if (!my_connect_socket(-1, t, caddr[p].sin_addr.s_addr, ntohs(caddr[p].sin_port)))
                                 t = -1;
                               else
                                 par[t] = p;
                             }
                           }
                           if (t != -1)
                           {
                             lnk[t][j] = lnk[p][i];
                             ctl_send(-1, -1, "lnk[%d,%d]=%d", t,j,lnk[t][j]);
                           }
                         }

                       }//for p

                       for(int t=0; t<MAXOBJECTS; t++)
                       if (t != j)
                       if (status[t] == STATUS_DATA)
                       if (par[t] != LINK_NONE)
                       if (status[par[t]] == STATUS_LISTEN_DATA)
                       {
                         if (lnk[i][par[t]] != LT_NONE)
                         if ( (lnk[i][par[t]] == LT_MULTI_KEEP) ||
                              (lnk[i][par[t]] == LT_MULTI_DROP) ||
                              (
                                (
                                  (get_lnk_count(j,LT_ANY) == 0) ||
                                  (get_lnk_count(j,LT_ANY) == 1 && lnk[j][t] != LT_NONE)
                                )
                                &&
                                (
                                  (get_lnk_count(t,LT_ANY) == 0) ||
                                  (get_lnk_count(t,LT_ANY) == 1 && lnk[t][j] != LT_NONE)
                                )
                              )
                            )
                         {
                           lnk[j][t] = lnk[i][par[t]];
                           ctl_send(-1, -1, "lnk[%d,%d]=%d", j,t,lnk[j][t]);
                         }
                         if (lnk[par[t]][i] != LT_NONE)
                         if ( (lnk[par[t]][i] == LT_MULTI_KEEP) ||
                              (lnk[par[t]][i] == LT_MULTI_DROP) ||
                              (
                                (
                                  (get_lnk_count(t,LT_ANY) == 0) ||
                                  (get_lnk_count(t,LT_ANY) == 1 && lnk[t][j] != LT_NONE)
                                )
                                &&
                                (
                                  (get_lnk_count(j,LT_ANY) == 0) ||
                                  (get_lnk_count(j,LT_ANY) == 1 && lnk[j][t] != LT_NONE)
                                )
                              )
                            )
                         {
                           lnk[t][j] = lnk[par[t]][i];
                           ctl_send(-1, -1, "lnk[%d,%d]=%d", t,j,lnk[t][j]);
                         }
                       }//for t

                     } // STATUS_LISTEN_DATA --> STATUS_DATA

                     if (status[j] == STATUS_CTL)
                     {
                       ctl_send(j, j, BANNER);
                     }

                   } // accept ok
                 } // allocated j
               } // select, res == 1

             }
             break;

        case STATUS_DATA:
        case STATUS_CTL:
             {
               fd_set readfds;
               FD_ZERO(&readfds);
               FD_SET(sock[i], &readfds);

               timeval to = {0,0};

               res = select(sock[i]+1, &readfds, NULL, NULL, &to);

               if (res == -1)
               {
                 idle = 0;

                 //printf("killed io %d\n", i);

                 my_close_socket(-1, i);
                 break;
               } // res == -1

               if (res == 1)
               {
                 idle = 0;

                 static char temp[4096+1];
                 int res = recv(sock[i], temp, sizeof(temp)-1, MSG_NOSIGNAL);
                 if ((res == 0) || (res == -1))
                 {
                   //printf("killed io %d\n", i);

                   my_close_socket(-1, i);
                   break;
                 }

                 //printf("received %d bytes from %d\n", res, i);

                 if (status[i] == STATUS_CTL)
                 {
                   control(i, temp, res);
#ifdef PROMPT
                   ctl_send(-1, i, PROMPT);
#endif
                 }
                 else // STATUS_DATA
                 {
                   for(j=0; j<MAXOBJECTS; j++)
                   //if (j != i)
                   if (lnk[i][j])
                   {
                     res = send(sock[j], temp, res, MSG_NOSIGNAL);
                     if ((res == 0) || (res == -1))
                     {
                       //printf("killed io %d\n", j);

                       my_close_socket(-1, j);
                       break;
                     }

                     //printf("sent %d bytes from %d to %d\n", i, j);
                   }
                 }
               } // res == 1

             }
             break;

      } // switch(status[i])

    } // for i -- for each socket

    if (idle)
    {
#ifdef WIN32
      Sleep(10);
#endif
#ifdef LINUX
      usleep(10*1000);
#endif
    }

  } // for(;;) -- main cycle

#ifdef WIN32
  WSACleanup();
#endif

  return 0;
} // main

// [EOF]
