
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>

#define out_asm "DEN.INC"
#define out_c   "DEN.H"

#define MAXBIT  8192
#define MAXWORD (MAXBIT/16)

int n=3;

int num[6]={0,0,0,0,0,0};
int arr[6][MAXWORD*2];

char* den_str[6] = {"d","e","n","p","q","u"};

void main(int argc, char* argv[])
{
  printf("TXT2DEN  build 001  z0mbie.cjb.net\n");

  char filename[256]="";
  memset(arr,0,sizeof(arr));

  for (int i=1; i<argc; i++)
    if (argv[i][0]=='/')
    {
      if (stricmp(argv[i],"/x")==0)
        n=6;
      else
      {
        printf("***ERROR***: unknown option %s\n", argv[i]);
        exit(0);
      }
    }
    else
      strcpy(filename,argv[i]);

  if (filename[0]==0)
  {
    printf("this utility used to extract D,E,N numbers from PGP output\n"\
           "Syntax: TXT2DEN [/x] filename\n"\
           "    ('/x' option means process d,e,n and also p,q,u numbers)\n");
    exit(0);
  }


  FILE*f = fopen(filename,"rb");
  if (f==NULL)
  {
    printf("***ERROR***: can not open file %s\n", filename);
    exit(0);
  }

  printf("processing %s\n", filename);

  int i,j=0;
  char s[1024]="";

  while (!feof(f))
  {
    char c=fgetc(f);
    if ((c==0x20)||(c==0x09)||(c==0x0D)||(c==0x0A)||feof(f))
    {
      if (strlen(s)>4) j=0;
      if (j==0)
      {
        for (int k=0; k<n; k++)
          if (strcmp(s,den_str[k])==0)
            {
              j=1;
              i=k;
              if (num[i]!=0)
              {
                printf("***ERROR***: more than 1 key in file. you should use NEW file for each PGP keygen session.\n");
                exit(0);
              }
              printf("found %s\n",den_str[k]);
            };
      }
      if (strcmp(s,"=")==0) if (j==1) j=2; else j=0;
      if ((j==2)&&(strlen(s)==4))
      {
        for (int k=0; k<4; k++)
          if (((s[k]<'0')&&(s[k]>'9'))&&
              ((s[k]<'A')&&(s[k]>'F')))
          {
            printf("***ERROR***: error analyzing file\n");
            exit(0);
          }
        sscanf(s,"%04X",&arr[i][MAXWORD-1-num[i]++]);
      }
      s[0]=0;
    }
    else
      *(unsigned short*)&s[strlen(s)]=c;
  }
  fclose(f);

  int maxword=0;
  for (int k=0; k<n; k++)
  {
    if (num[k]==0)
    {
      printf("***ERROR***: something wrong with your fucking file (%s not found)\n"\
             "\n"\
             "btw, if you dont know what to do now, i'll tell you:\n"\
             "1. get PGP 2.6.x\n"\
             "2. run scrgrab.com textfile PGP.EXE -l -kg\n"\
             "3. run TXT2DEN textfile\n",den_str[k]);
      exit(0);
    }
    maxword=max(maxword,num[k]);
  }
  maxword = (maxword+1)&~1;

  printf("writing %s\n", out_asm);
  f = fopen(out_asm,"wb");
  assert(f!=NULL);
  fprintf(f,"\nrsa_bit                  equ     %i\n\n",maxword*16);
  for (int i=0; i<n; i++)
  {
    fprintf(f,"rsa_%s                    label   dword\n",den_str[i]);
    for (int j=0, c=0; j<maxword; j+=2, c++)
      fprintf(f,"%s0%04X%04Xh%s",
        ((c%4)==0)?"dd ":"",
        arr[i][MAXWORD-num[i]+j+1],
        arr[i][MAXWORD-num[i]+j+0],
        (((c%4)==3)||(j>=maxword-2))?"\n":",");
    fprintf(f,"dd 0\n");
    fprintf(f,"\n");
  }
  fclose(f);

  printf("writing %s\n", out_c);
  f = fopen(out_c,"wb");
  assert(f!=NULL);
  fprintf(f,"\n#define rsa_bit %i\n\n",maxword*16);
  for (int i=0; i<n; i++)
  {
    fprintf(f,"DWORD rsa_%s[%i] = {\n",den_str[i],maxword/2);
    for (int j=0, c=0; j<maxword; j+=2, c++)
      fprintf(f,"%s0x%04X%04X%s%s",((c%4)==0)?"  ":"",
        arr[i][MAXWORD-num[i]+j+1],
        arr[i][MAXWORD-num[i]+j+0],
        (j>=maxword-2)?"":",",((c%4)==3)?"\n":"");
    fprintf(f,"};\n\n");
  }
  fclose(f);

}
