#include "StdAfx.h"
#include "ConnectorBridge.h"
#include "GateRelay.h"

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
FSecure::C3::Core::ConnectorBridge::ConnectorBridge(std::shared_ptr<GateRelay>&& gateway, std::shared_ptr<AbstractConnector>&& connector, std::string name, HashT nameHash)
	: m_Name{ name }
	, m_NameHash{ nameHash }
	, m_GateRelay{ gateway }
	, m_Connector{ std::move(connector) }
{
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void FSecure::C3::Core::ConnectorBridge::OnAttach()
{
	GetConnector()->OnAttach(shared_from_this());
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void FSecure::C3::Core::ConnectorBridge::Detach()
{
	m_IsAlive = false;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void FSecure::C3::Core::ConnectorBridge::TurnOff()
{
	auto gateway = GetGateRelay();
	gateway->TurnOffConnector(GetNameHash());
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void FSecure::C3::Core::ConnectorBridge::PostCommandToBinder(ByteView binderId, ByteView command)
{
	return GetGateRelay()->PostCommandToPeripheral(command, binderId.Read<RouteId>());
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void FSecure::C3::Core::ConnectorBridge::OnCommandFromBinder(ByteView binderId, ByteView command)
{
	return GetConnector()->OnCommandFromBinder(binderId, command);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
FSecure::ByteVector FSecure::C3::Core::ConnectorBridge::RunCommand(ByteView command)
{
	return GetConnector()->OnRunCommand(command);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void FSecure::C3::Core::ConnectorBridge::Log(LogMessage const& message)
{
	if (auto gate = GetGateRelay())
		gate->Log(message);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
std::string FSecure::C3::Core::ConnectorBridge::GetName() const
{
	return m_Name;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
FSecure::HashT FSecure::C3::Core::ConnectorBridge::GetNameHash() const
{
	return m_NameHash;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
std::shared_ptr<FSecure::C3::AbstractConnector> FSecure::C3::Core::ConnectorBridge::GetConnector() const
{
	return m_Connector;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
std::shared_ptr<FSecure::C3::Core::GateRelay> FSecure::C3::Core::ConnectorBridge::GetGateRelay() const
{
	return m_GateRelay.lock();
}
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void FSecure::C3::Core::ConnectorBridge::SetErrorStatus(std::string_view errorMessage)
{
	m_Error = errorMessage;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
std::string FSecure::C3::Core::ConnectorBridge::GetErrorStatus()
{
	return m_Error;
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
FSecure::ByteVector FSecure::C3::Core::ConnectorBridge::PeripheralCreationCommand(ByteView connectionId, ByteView data, bool isX64)
{
	return m_Connector->PeripheralCreationCommand(connectionId, data, isX64);
}

FSecure::ByteVector FSecure::C3::Core::ConnectorBridge::CloseConnection(ByteView connectionId)
{
	return m_Connector->CloseConnection(connectionId);
}
